/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.ActivityCategory;
import org.jetbrains.kotlin.com.intellij.diagnostic.StartUpMeasurer;
import org.jetbrains.kotlin.com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LoadingOrder;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.EmptyRunnable;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.kotlin.org.jdom.Element;

@ApiStatus.Internal
public abstract class ExtensionPointImpl<@NotNull T>
implements ExtensionPoint<T>,
Iterable<T> {
    private static final ExtensionPointListener<?>[] EMPTY_ARRAY = new ExtensionPointListener[0];
    static final Logger LOG = Logger.getInstance(ExtensionPointImpl.class);
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    private volatile T @Nullable [] myExtensionsCacheAsArray;
    private ComponentManager componentManager;
    @NotNull
    protected final PluginDescriptor pluginDescriptor;
    @NotNull
    private volatile List<ExtensionComponentAdapter> myAdapters;
    private volatile boolean adaptersIsSorted;
    private ExtensionPointListener<T> @NotNull [] myListeners;
    @Nullable
    private Class<T> myExtensionClass;
    private final boolean isDynamic;
    private final AtomicReference<ConcurrentMap<?, Map<?, ?>>> keyMapperToCacheRef;
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name2, @NotNull String className2, @NotNull PluginDescriptor pluginDescriptor, @Nullable Class<T> extensionClass, boolean dynamic) {
        if (name2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        this.myAdapters = Collections.emptyList();
        this.adaptersIsSorted = true;
        this.myListeners = EMPTY_ARRAY;
        this.keyMapperToCacheRef = new AtomicReference();
        this.myName = name2;
        this.myClassName = className2;
        this.pluginDescriptor = pluginDescriptor;
        this.myExtensionClass = extensionClass;
        this.isDynamic = dynamic;
    }

    final void setComponentManager(@NotNull ComponentManager value2) {
        if (value2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.componentManager = value2;
    }

    @NotNull
    public final String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public final String getClassName() {
        String string2 = this.myClassName;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public final boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), null);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.registerExtension(extension, this.getPluginDescriptor(), parentDisposable);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, pluginDescriptor, parentDisposable);
    }

    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        return pluginDescriptor;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), parentDisposable);
    }

    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull PluginDescriptor pluginDescriptor, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).componentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, pluginDescriptor, order);
        this.addExtensionAdapter(adapter);
        this.notifyListeners(false, Collections.singletonList(adapter), this.myListeners);
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    int index2 = ContainerUtil.indexOfIdentity(this.myAdapters, adapter);
                    if (index2 < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.componentInstance);
                    }
                    ArrayList<ExtensionComponentAdapter> list2 = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                    list2.remove(index2);
                    this.myAdapters = list2;
                    this.clearCache();
                    this.notifyListeners(true, Collections.singletonList(adapter), this.myListeners);
                }
            });
        }
    }

    private void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        if (!extensionClass.isInstance(extension)) {
            @NonNls String message = "Extension " + extension.getClass() + " does not implement " + extensionClass;
            if (adapter != null) {
                message = message + " (adapter=" + adapter + ")";
            }
            throw new ExtensionException(message, extension.getClass());
        }
    }

    @Override
    @NotNull
    public final List<T> getExtensionList() {
        List<T> result2 = this.myExtensionsCache;
        List<T> list2 = result2 != null ? result2 : this.calcExtensionList();
        if (list2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    private synchronized List<T> calcExtensionList() {
        List<T> result2 = this.myExtensionsCache;
        if (result2 == null) {
            T[] array2 = this.processAdapters();
            this.myExtensionsCacheAsArray = array2;
            this.myExtensionsCache = result2 = array2.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T @NotNull [] getExtensions() {
        T[] array2 = this.myExtensionsCacheAsArray;
        if (array2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array2 = this.myExtensionsCacheAsArray;
                if (array2 == null) {
                    this.myExtensionsCacheAsArray = array2 = this.processAdapters();
                    this.myExtensionsCache = array2.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array2);
                }
            }
        }
        Object[] objectArray = array2.length == 0 ? array2 : (Object[])array2.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        return objectArray;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public final Iterator<T> iterator() {
        List<T> result2 = this.myExtensionsCache;
        Iterator<T> iterator2 = result2 == null ? this.createIterator() : result2.iterator();
        if (iterator2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        return iterator2;
    }

    @NotNull
    private List<ExtensionComponentAdapter> getThreadSafeAdapterList(boolean failIfListenerAdded) {
        CHECK_CANCELED.run();
        if (!this.isDynamic && this.myListeners.length > 0) {
            String message = "Listeners not allowed for extension point " + this.getName();
            if (failIfListenerAdded) {
                LOG.error(message);
            } else {
                LOG.warn(message);
                this.getExtensionList();
            }
        }
        return this.getSortedAdapters();
    }

    @NotNull
    private Iterator<T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getThreadSafeAdapterList(true);
        final int size = adapters.size();
        if (size == 0) {
            Iterator iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(31);
            }
            return iterator2;
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
    }

    @Override
    public final Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1281);
    }

    @Override
    public final int size() {
        List<T> cache2 = this.myExtensionsCache;
        return cache2 == null ? this.myAdapters.size() : cache2.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<ExtensionComponentAdapter> getSortedAdapters() {
        if (this.adaptersIsSorted) {
            List<ExtensionComponentAdapter> list2 = this.myAdapters;
            if (list2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(33);
            }
            return list2;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            if (this.adaptersIsSorted) {
                List<ExtensionComponentAdapter> list3 = this.myAdapters;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                if (list3 == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(34);
                }
                return list3;
            }
            if (this.myAdapters.size() > 1) {
                ArrayList<ExtensionComponentAdapter> list4 = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                LoadingOrder.sort(list4);
                this.myAdapters = list4;
            }
            this.adaptersIsSorted = true;
        }
        List<ExtensionComponentAdapter> list5 = this.myAdapters;
        if (list5 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(35);
        }
        return list5;
    }

    private T @NotNull [] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = StartUpMeasurer.getCurrentTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        T[] result2 = ArrayUtil.newArray(extensionClass, totalSize);
        if (totalSize == 0) {
            if (result2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(36);
            }
            return result2;
        }
        Set duplicates = this instanceof BeanExtensionPoint ? null : CollectionFactory.createSmallMemoryFootprintSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            T extension = this.processAdapter(adapters.get(i), listeners, result2, duplicates, extensionClass, adapters);
            if (extension == null) continue;
            result2[extensionIndex++] = extension;
        }
        if (extensionIndex != result2.length) {
            result2 = Arrays.copyOf(result2, extensionIndex);
        }
        ActivityCategory category = ExtensionPointImpl.getActivityCategory((DefaultPicoContainer)this.componentManager.getPicoContainer());
        StartUpMeasurer.addCompletedActivity(startTime, extensionClass, category, null, StartUpMeasurer.MEASURE_THRESHOLD);
        if (result2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        return result2;
    }

    @NotNull
    public abstract ExtensionPointImpl<T> cloneFor(@NotNull ComponentManager var1);

    @NotNull
    private static ActivityCategory getActivityCategory(@NotNull DefaultPicoContainer picoContainer) {
        DefaultPicoContainer parent2;
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        if ((parent2 = picoContainer.getParent()) == null) {
            ActivityCategory activityCategory = ActivityCategory.APP_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(39);
            }
            return activityCategory;
        }
        if (parent2.getParent() == null) {
            ActivityCategory activityCategory = ActivityCategory.PROJECT_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(40);
            }
            return activityCategory;
        }
        ActivityCategory activityCategory = ActivityCategory.MODULE_EXTENSION;
        if (activityCategory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(41);
        }
        return activityCategory;
    }

    @Nullable
    private synchronized T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(42);
        }
        try {
            if (!ExtensionPointImpl.checkThatClassloaderIsActive(adapter)) {
                return null;
            }
            return adapter.createInstance(this.componentManager);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, ExtensionPointListener<T> @Nullable [] listeners, T @Nullable [] result2, @Nullable Set<T> duplicates, @NotNull Class<T> extensionClassForCheck, @NotNull List<? extends ExtensionComponentAdapter> adapters) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (extensionClassForCheck == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        try {
            Object duplicate;
            if (!ExtensionPointImpl.checkThatClassloaderIsActive(adapter)) {
                return null;
            }
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated() && !this.isDynamic;
            Object extension = adapter.createInstance(this.componentManager);
            if (duplicates != null && !duplicates.add(extension)) {
                duplicate = ContainerUtil.find(duplicates, d -> d.equals(extension));
                assert (result2 != null);
            } else {
                this.checkExtensionType(extension, extensionClassForCheck, adapter);
                if (isNotifyThatAdded) {
                    this.notifyListeners(false, Collections.singletonList(adapter), listeners);
                }
                return extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result2) + ";\n  adapters:        " + adapters);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private static boolean checkThatClassloaderIsActive(@NotNull ExtensionComponentAdapter adapter) {
        ClassLoader classLoader2;
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        if ((classLoader2 = adapter.getPluginDescriptor().getPluginClassLoader()) instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)classLoader2)).getState() != 1) {
            LOG.warn(adapter + " not loaded because classloader is being unloaded");
            return false;
        }
        return true;
    }

    @Override
    public final void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(53);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$9(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    public final boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(54);
        }
        ArrayList<Runnable> listenerCallbacks = new ArrayList<Runnable>();
        ArrayList<Runnable> priorityListenerCallbacks = new ArrayList<Runnable>();
        boolean result2 = this.unregisterExtensions(adapter -> extensionClassFilter.test(adapter.getAssignableToClassName(), (ExtensionComponentAdapter)adapter), stopAfterFirstMatch, priorityListenerCallbacks, listenerCallbacks);
        for (Runnable callback : priorityListenerCallbacks) {
            callback.run();
        }
        for (Runnable callback : listenerCallbacks) {
            callback.run();
        }
        return result2;
    }

    final synchronized boolean unregisterExtensions(@NotNull Predicate<? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(55);
        }
        if (priorityListenerCallbacks == null) {
            ExtensionPointImpl.$$$reportNull$$$0(56);
        }
        if (listenerCallbacks == null) {
            ExtensionPointImpl.$$$reportNull$$$0(57);
        }
        ExtensionPointListener<T>[] listeners = this.myListeners;
        ArrayList<ExtensionComponentAdapter> removedAdapters = null;
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (extensionClassFilter.test(adapter)) continue;
            if (adapters == this.myAdapters) {
                adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
            }
            adapters.remove(i);
            if (listeners.length != 0) {
                if (removedAdapters == null) {
                    removedAdapters = new ArrayList<ExtensionComponentAdapter>();
                }
                removedAdapters.add(adapter);
            }
            if (stopAfterFirstMatch) break;
        }
        if (adapters == this.myAdapters) {
            return false;
        }
        this.clearCache();
        this.myAdapters = adapters;
        if (removedAdapters == null) {
            return true;
        }
        List<ExtensionPointListener> priorityListeners = ContainerUtil.filter(listeners, listener -> listener instanceof ExtensionPointPriorityListener);
        List<ExtensionPointListener> regularListeners = ContainerUtil.filter(listeners, listener -> !(listener instanceof ExtensionPointPriorityListener));
        ArrayList<ExtensionComponentAdapter> finalRemovedAdapters = removedAdapters;
        if (!priorityListeners.isEmpty()) {
            priorityListenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, priorityListeners.toArray(new ExtensionPointListener[0])));
        }
        if (!regularListeners.isEmpty()) {
            listenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, regularListeners.toArray(new ExtensionPointListener[0])));
        }
        return true;
    }

    private void notifyListeners(boolean isRemoved, @NotNull List<ExtensionComponentAdapter> adapters, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(58);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(59);
        }
        for (ExtensionPointListener listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (ExtensionComponentAdapter adapter : adapters) {
                if (isRemoved && !adapter.isInstanceCreated()) continue;
                try {
                    Object extension = adapter.createInstance(this.componentManager);
                    if (isRemoved) {
                        listener.extensionRemoved(extension, adapter.getPluginDescriptor());
                        continue;
                    }
                    listener.extensionAdded(extension, adapter.getPluginDescriptor());
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (ExtensionNotApplicableException e) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded;
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(60);
        }
        if ((isAdded = this.addListener(listener)) && invokeForLoadedExtensions) {
            this.notifyListeners(false, this.myAdapters, new ExtensionPointListener[]{listener});
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        ArrayFactory<ExtensionPointListener<T>> arrayFactory = LISTENER_ARRAY_FACTORY;
        if (arrayFactory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(61);
        }
        return arrayFactory;
    }

    private boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(62);
        }
        if (ArrayUtilRt.indexOf(this.myListeners, listener, 0, this.myListeners.length) != -1) {
            return false;
        }
        this.myListeners = listener instanceof ExtensionPointPriorityListener ? ArrayUtil.prepend(listener, this.myListeners, ExtensionPointImpl.listenerArrayFactory()) : ArrayUtil.append(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    public final void addChangeListener(final @NotNull Runnable listener, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(65);
        }
        ExtensionPointAdapter listenerAdapter = new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.run();
            }
        };
        this.myListeners = ArrayUtil.append(this.myListeners, listenerAdapter, ExtensionPointImpl.listenerArrayFactory());
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listenerAdapter));
        }
    }

    @Override
    public final synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(66);
        }
        this.myListeners = ArrayUtil.remove(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    @NotNull
    public final Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.pluginDescriptor.getPluginClassLoader();
                this.myExtensionClass = extensionClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw this.componentManager.createError(e, this.pluginDescriptor.getPluginId());
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(67);
        }
        return clazz;
    }

    public final String toString() {
        return this.getName();
    }

    final synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(68);
        }
        ArrayList<ExtensionComponentAdapter> list2 = new ArrayList<ExtensionComponentAdapter>(this.myAdapters.size() + 1);
        list2.addAll(this.myAdapters);
        list2.add(adapter);
        this.myAdapters = list2;
        this.clearCache();
    }

    final void clearUserCache() {
        ConcurrentMap<?, Map<?, ?>> map2 = this.keyMapperToCacheRef.get();
        if (map2 != null) {
            map2.clear();
        }
    }

    private void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.adaptersIsSorted = false;
        this.clearUserCache();
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    final synchronized void registerExtensions(@NotNull List<? extends Element> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable List<? super Runnable> listenerCallbacks) {
        List<ExtensionComponentAdapter> adapters;
        if (extensionElements == null) {
            ExtensionPointImpl.$$$reportNull$$$0(72);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(73);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(74);
        }
        if (this.componentManager != componentManager) {
            LOG.error("The same point on different levels (pointName=" + this.getName() + ")");
        }
        if ((adapters = this.myAdapters) == Collections.emptyList()) {
            this.myAdapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.adaptersIsSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (Element element : extensionElements) {
            adapters.add(this.createAdapterAndRegisterInPicoContainerIfNeeded(element, pluginDescriptor, componentManager));
        }
        int newSize = adapters.size();
        this.clearCache();
        ExtensionPointListener[] extensionPointListenerArray = this.myListeners;
        if (listenerCallbacks == null || extensionPointListenerArray.length == 0) {
            return;
        }
        List addedAdapters = Collections.emptyList();
        for (ExtensionPointListener<T> extensionPointListener : extensionPointListenerArray) {
            if (extensionPointListener instanceof ExtensionPointAdapter) continue;
            List<ExtensionComponentAdapter> newlyAddedUnsortedList = adapters.subList(oldSize, newSize);
            Set newlyAddedSet = Collections.newSetFromMap(new IdentityHashMap(newlyAddedUnsortedList.size()));
            newlyAddedSet.addAll(newlyAddedUnsortedList);
            addedAdapters = new ArrayList(newlyAddedSet.size());
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                if (!newlyAddedSet.contains(adapter)) continue;
                addedAdapters.add(adapter);
            }
            break;
        }
        List finalAddedAdapters = addedAdapters;
        Runnable runnable = () -> this.notifyListeners(false, finalAddedAdapters, listeners);
        listenerCallbacks.add(runnable);
    }

    @TestOnly
    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(75);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> aClass, boolean isRequired, @NotNull ThreeState strictMatch) {
        List<T> extensionsCache;
        if (aClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(76);
        }
        if (strictMatch == null) {
            ExtensionPointImpl.$$$reportNull$$$0(77);
        }
        if (strictMatch != ThreeState.NO) {
            V result2 = this.findExtensionByExactClass(aClass);
            if (result2 != null) {
                return result2;
            }
            if (strictMatch == ThreeState.YES) {
                return null;
            }
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                try {
                    if (!aClass.isAssignableFrom(adapter.getImplementationClass())) continue;
                    return (V)this.processAdapter(adapter);
                }
                catch (ClassNotFoundException e) {
                    this.componentManager.logError(e, adapter.getPluginDescriptor().getPluginId());
                }
            }
        } else {
            for (Object extension : extensionsCache) {
                if (!aClass.isInstance(extension)) continue;
                return (V)extension;
            }
        }
        if (isRequired) {
            @NonNls String message = "could not find extension implementation " + aClass;
            if (this.isInReadOnlyMode()) {
                message = message + " (point in read-only mode)";
            }
            throw new IllegalArgumentException(message);
        }
        return null;
    }

    @Nullable
    private T findExtensionByExactClass(@NotNull Class<? extends T> aClass) {
        List<T> extensionsCache;
        if (aClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(78);
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                Object classOrName = adapter.implementationClassOrName;
                if (!(classOrName instanceof String ? classOrName.equals(aClass.getName()) : classOrName == aClass)) continue;
                return this.processAdapter(adapter);
            }
        } else {
            for (T extension : extensionsCache) {
                if (aClass != extension.getClass()) continue;
                return extension;
            }
        }
        return null;
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$9(String classNameToUnregister, String className2, ExtensionComponentAdapter adapter) {
        return !className2.equals(classNameToUnregister);
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? EMPTY_ARRAY : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 61: 
            case 67: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 61: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 12: 
            case 20: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 23: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 21: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 22: 
            case 45: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapters";
                break;
            }
            case 24: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 42: 
            case 43: 
            case 46: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassForCheck";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 50: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityListenerCallbacks";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerCallbacks";
                break;
            }
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElements";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictMatch";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedAdapters";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "listenerArrayFactory";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setComponentManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 61: 
            case 67: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtension";
                break;
            }
            case 21: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionIndexForAnyOrder";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkExtensionType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processWithPluginDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processImplementations";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processIdentifiableImplementations";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getActivityCategory";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processAdapter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkThatClassloaderIsActive";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "doNotifyListeners";
                break;
            }
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "notifyListeners";
                break;
            }
            case 60: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionAdapter";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByExactClass";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "setCheckCanceledAction";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 61: 
            case 67: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        @NotNull
        private final T componentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            super(extension.getClass().getName(), pluginDescriptor, null, loadingOrder);
            this.componentInstance = extension;
        }

        @Override
        boolean isInstanceCreated() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            T t = this.componentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(3);
            }
            return (I)t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

