/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.metadata;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.DefaultMetadata;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;

public abstract class AbstractMetadata
implements Metadata {
    private Metadata newInstance(Map<String, String> properties2, File file2) {
        return new DefaultMetadata(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getNature(), file2, properties2);
    }

    @Override
    public Metadata setFile(File file2) {
        File current = this.getFile();
        if (Objects.equals(current, file2)) {
            return this;
        }
        return this.newInstance(this.getProperties(), file2);
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties2) {
        if (properties2 != null && !properties2.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties2));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.getGroupId().length() > 0) {
            buffer.append(this.getGroupId());
        }
        if (this.getArtifactId().length() > 0) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (this.getVersion().length() > 0) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)obj;
        return Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getType(), that.getType()) && Objects.equals((Object)this.getNature(), (Object)that.getNature()) && Objects.equals(this.getFile(), that.getFile()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getType().hashCode();
        hash = hash * 31 + this.getNature().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractMetadata.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

