/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0005R2\u0010\u0003\u001a&\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/container/ClassTraversalCache;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getClassInfo", "c", "container"})
final class ClassTraversalCache {
    @NotNull
    public static final ClassTraversalCache INSTANCE;
    @NotNull
    private static final ConcurrentMap<Class<?>, ClassInfo> cache;

    private ClassTraversalCache() {
    }

    @NotNull
    public final ClassInfo getClassInfo(@NotNull Class<?> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        ClassInfo classInfo2 = (ClassInfo)cache.get(c);
        if (classInfo2 == null) {
            ClassInfo newClassInfo = CacheKt.access$traverseClass(c);
            cache.put(c, newClassInfo);
            return newClassInfo;
        }
        return classInfo2;
    }

    static {
        ConcurrentMap concurrentMap;
        INSTANCE = new ClassTraversalCache();
        if (System.getProperty("idea.system.path") != null) {
            concurrentMap = new ConcurrentHashMap();
        } else {
            ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakKeySoftValueMap();
            concurrentMap = concurrentMap2;
            Intrinsics.checkNotNullExpressionValue(concurrentMap2, "createConcurrentWeakKeyS\u2026ap<Class<*>, ClassInfo>()");
        }
        cache = concurrentMap;
    }
}

