/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J>\u0010\u0013\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationOnSuperclass", "superTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkClassCannotBeExtendedDirectly", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "checkDelegationNotToInterface", "checkExpandedTypeCannotBeInherited", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "fullyExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneType", "checkProjectionInImmediateArgumentToSupertype", "checkers"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        boolean nullableSupertypeReported = false;
        boolean extensionFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = false;
        interfaceWithSuperclassReported = !isInterface;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        HashSet superClassSymbols = new HashSet();
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            Object object;
            ConeKotlinType fullyExpandedType2;
            boolean $i$f$getModality;
            FirClassLikeSymbol<?> superTypeSymbol;
            Object lookupTag2;
            boolean $i$f$safeAs;
            ConeKotlinType $this$safeAs$iv;
            ConeKotlinType coneType;
            boolean bl;
            CheckerContext ctx;
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(superTypeRef);
            if (arguments$iv != null) {
                Object object2;
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                ctx = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                coneType = FirTypeUtilsKt.getConeType(superTypeRef);
                if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), (DiagnosticContext)ctx, null, 8, null);
                    nullableSupertypeReported = true;
                }
                if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(ctx.getSession()).supportsFeature(LanguageFeature.FunctionalTypeWithExtensionAsSupertype)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)ctx, null, 8, null);
                    extensionFunctionSupertypeReported = true;
                }
                $this$safeAs$iv = coneType;
                $i$f$safeAs = false;
                ConeKotlinType coneKotlinType = $this$safeAs$iv;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((object2 = (ConeClassLikeType)coneKotlinType) == null || (object2 = ((ConeClassLikeType)object2).getLookupTag()) == null) continue;
                lookupTag2 = object2;
                superTypeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, ctx.getSession());
                if (superTypeSymbol instanceof FirRegularClassSymbol) {
                    boolean isObject;
                    if (!superClassSymbols.add(superTypeSymbol)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), (DiagnosticContext)ctx, null, 8, null);
                    }
                    if (((FirRegularClassSymbol)superTypeSymbol).getClassKind() != ClassKind.INTERFACE) {
                        if (classAppeared) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), (DiagnosticContext)ctx, null, 8, null);
                        } else {
                            classAppeared = true;
                        }
                        if (!interfaceWithSuperclassReported) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), (DiagnosticContext)ctx, null, 8, null);
                            interfaceWithSuperclassReported = true;
                        }
                    }
                    boolean bl2 = isObject = ((FirRegularClassSymbol)superTypeSymbol).getClassKind() == ClassKind.OBJECT;
                    if (!finalSupertypeReported && !isObject) {
                        FirClassSymbol $this$modality$iv = (FirClassSymbol)superTypeSymbol;
                        $i$f$getModality = false;
                        if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), (DiagnosticContext)ctx, null, 8, null);
                            finalSupertypeReported = true;
                        }
                    }
                    if (!singletonInSupertypeReported && isObject) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), (DiagnosticContext)ctx, null, 8, null);
                        singletonInSupertypeReported = true;
                    }
                }
                INSTANCE.checkAnnotationOnSuperclass(superTypeRef, ctx, reporter2);
                fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(coneType, ctx.getSession());
                FirClassifierSymbol<?> symbol2 = TypeUtilsKt.toSymbol(fullyExpandedType2, ctx.getSession());
                INSTANCE.checkClassCannotBeExtendedDirectly(symbol2, reporter2, superTypeRef, ctx);
                if (!(coneType.getTypeArguments().length == 0)) {
                    INSTANCE.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter2, ctx);
                    continue;
                }
                INSTANCE.checkExpandedTypeCannotBeInherited((FirBasedSymbol)symbol2, fullyExpandedType2, reporter2, superTypeRef, coneType, ctx);
                continue;
            }
            ctx = (CheckerContext)((MutableDiagnosticContext)context);
            bl = false;
            coneType = FirTypeUtilsKt.getConeType(superTypeRef);
            if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), (DiagnosticContext)ctx, null, 8, null);
                nullableSupertypeReported = true;
            }
            if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(ctx.getSession()).supportsFeature(LanguageFeature.FunctionalTypeWithExtensionAsSupertype)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)ctx, null, 8, null);
                extensionFunctionSupertypeReported = true;
            }
            $this$safeAs$iv = coneType;
            $i$f$safeAs = false;
            ConeKotlinType coneKotlinType = $this$safeAs$iv;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeClassLikeType)coneKotlinType) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) continue;
            lookupTag2 = object;
            superTypeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, ctx.getSession());
            if (superTypeSymbol instanceof FirRegularClassSymbol) {
                boolean isObject;
                if (!superClassSymbols.add(superTypeSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), (DiagnosticContext)ctx, null, 8, null);
                }
                if (((FirRegularClassSymbol)superTypeSymbol).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), (DiagnosticContext)ctx, null, 8, null);
                    } else {
                        classAppeared = true;
                    }
                    if (!interfaceWithSuperclassReported) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), (DiagnosticContext)ctx, null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl3 = isObject = ((FirRegularClassSymbol)superTypeSymbol).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject) {
                    FirClassSymbol $this$modality$iv = (FirClassSymbol)superTypeSymbol;
                    $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), (DiagnosticContext)ctx, null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), (DiagnosticContext)ctx, null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            INSTANCE.checkAnnotationOnSuperclass(superTypeRef, ctx, reporter2);
            fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(coneType, ctx.getSession());
            FirClassifierSymbol<?> symbol3 = TypeUtilsKt.toSymbol(fullyExpandedType2, ctx.getSession());
            INSTANCE.checkClassCannotBeExtendedDirectly(symbol3, reporter2, superTypeRef, ctx);
            if (!(coneType.getTypeArguments().length == 0)) {
                INSTANCE.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter2, ctx);
                continue;
            }
            INSTANCE.checkExpandedTypeCannotBeInherited((FirBasedSymbol)symbol3, fullyExpandedType2, reporter2, superTypeRef, coneType, ctx);
        }
        this.checkDelegationNotToInterface(declaration, context, reporter2);
        if (declaration instanceof FirRegularClass && declaration.getSuperTypeRefs().size() > 1) {
            FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(CollectionsKt.listOf(new Pair<Object, FirRegularClassSymbol>(null, ((FirRegularClass)declaration).getSymbol())), context, reporter2, declaration.getSource(), true);
        }
    }

    private final void checkAnnotationOnSuperclass(FirTypeRef superTypeRef, CheckerContext context, DiagnosticReporter reporter2) {
        for (FirAnnotation annotation2 : superTypeRef.getAnnotations()) {
            boolean bl;
            CheckerContext it;
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotation2);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                if (annotation2.getUseSiteTarget() == null) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), (DiagnosticContext)it, null, 8, null);
                continue;
            }
            it = (CheckerContext)((MutableDiagnosticContext)context);
            bl = false;
            if (annotation2.getUseSiteTarget() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), (DiagnosticContext)it, null, 8, null);
        }
    }

    private final void checkClassCannotBeExtendedDirectly(FirClassifierSymbol<?> symbol2, DiagnosticReporter reporter2, FirTypeRef superTypeRef, CheckerContext context) {
        if (symbol2 instanceof FirRegularClassSymbol && Intrinsics.areEqual(((FirRegularClassSymbol)symbol2).getClassId(), StandardClassIds.INSTANCE.getEnum())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), symbol2, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkProjectionInImmediateArgumentToSupertype(ConeKotlinType coneType, FirTypeRef superTypeRef, DiagnosticReporter reporter2, CheckerContext context) {
        List<FirTypeRefSource> list2 = FirHelpersKt.extractArgumentsTypeRefAndSource(superTypeRef);
        if (list2 == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list2;
        ConeTypeProjection[] coneTypeProjectionArray = coneType.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            int index2 = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
            FirTypeRefSource firTypeRefSource = CollectionsKt.getOrNull(typeRefAndSourcesForArguments, index2);
            if (firTypeRefSource == null) continue;
            KtSourceElement argSource = firTypeRefSource.component2();
            KtSourceElement ktSourceElement = argSource;
            if (ktSourceElement == null) {
                ktSourceElement = superTypeRef.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkExpandedTypeCannotBeInherited(FirBasedSymbol<?> symbol2, ConeKotlinType fullyExpandedType2, DiagnosticReporter reporter2, FirTypeRef superTypeRef, ConeKotlinType coneType, CheckerContext context) {
        if (symbol2 instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)symbol2).getClassKind() == ClassKind.INTERFACE) {
            for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
                if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getEXPANDED_TYPE_CANNOT_BE_INHERITED(), (Object)coneType, (DiagnosticContext)context, null, 16, null);
                break;
            }
        }
    }

    private final void checkDelegationNotToInterface(FirClass declaration, CheckerContext context, DiagnosticReporter reporter2) {
        for (FirDeclaration subDeclaration : declaration.getDeclarations()) {
            FirRegularClassSymbol delegatedClassSymbol;
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE) || !((FirField)subDeclaration).getName().isSpecial() || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName()) || (delegatedClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirField)subDeclaration).getReturnTypeRef(), context.getSession())) == null || delegatedClassSymbol.getClassKind() == ClassKind.INTERFACE) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirField)subDeclaration).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

