/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.message;

import org.jetbrains.kotlin.org.apache.http.Header;
import org.jetbrains.kotlin.org.apache.http.HttpVersion;
import org.jetbrains.kotlin.org.apache.http.ParseException;
import org.jetbrains.kotlin.org.apache.http.ProtocolVersion;
import org.jetbrains.kotlin.org.apache.http.StatusLine;
import org.jetbrains.kotlin.org.apache.http.message.BasicStatusLine;
import org.jetbrains.kotlin.org.apache.http.message.BufferedHeader;
import org.jetbrains.kotlin.org.apache.http.message.LineParser;
import org.jetbrains.kotlin.org.apache.http.message.ParserCursor;
import org.jetbrains.kotlin.org.apache.http.protocol.HTTP;
import org.jetbrains.kotlin.org.apache.http.util.Args;
import org.jetbrains.kotlin.org.apache.http.util.CharArrayBuffer;

public class BasicLineParser
implements LineParser {
    @Deprecated
    public static final BasicLineParser DEFAULT = new BasicLineParser();
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    protected final ProtocolVersion protocol;

    public BasicLineParser(ProtocolVersion proto) {
        this.protocol = proto != null ? proto : HttpVersion.HTTP_1_1;
    }

    public BasicLineParser() {
        this(null);
    }

    public ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        int minor;
        int major;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        this.skipWhitespace(buffer, cursor);
        int i = cursor.getPos();
        if (i + protolength + 4 > indexTo) {
            throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer.charAt(i + j) == protoname.charAt(j);
        }
        if (ok) {
            boolean bl = ok = buffer.charAt(i + protolength) == '/';
        }
        if (!ok) {
            throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
        }
        int period = buffer.indexOf(46, i += protolength + 1, indexTo);
        if (period == -1) {
            throw new ParseException("Invalid protocol version number: " + buffer.substring(indexFrom, indexTo));
        }
        try {
            major = Integer.parseInt(buffer.substringTrimmed(i, period));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid protocol major version number: " + buffer.substring(indexFrom, indexTo));
        }
        i = period + 1;
        int blank = buffer.indexOf(32, i, indexTo);
        if (blank == -1) {
            blank = indexTo;
        }
        try {
            minor = Integer.parseInt(buffer.substringTrimmed(i, blank));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid protocol minor version number: " + buffer.substring(indexFrom, indexTo));
        }
        cursor.updatePos(blank);
        return this.createProtocolVersion(major, minor);
    }

    protected ProtocolVersion createProtocolVersion(int major, int minor) {
        return this.protocol.forVersion(major, minor);
    }

    @Override
    public boolean hasProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
        int index2;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        if (buffer.length() < protolength + 4) {
            return false;
        }
        if (index2 < 0) {
            index2 = buffer.length() - 4 - protolength;
        } else if (index2 == 0) {
            for (index2 = cursor.getPos(); index2 < buffer.length() && HTTP.isWhitespace(buffer.charAt(index2)); ++index2) {
            }
        }
        if (index2 + protolength + 4 > buffer.length()) {
            return false;
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer.charAt(index2 + j) == protoname.charAt(j);
        }
        if (ok) {
            ok = buffer.charAt(index2 + protolength) == '/';
        }
        return ok;
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            int statusCode;
            ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
            this.skipWhitespace(buffer, cursor);
            int i = cursor.getPos();
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                blank = indexTo;
            }
            String s = buffer.substringTrimmed(i, blank);
            for (int j = 0; j < s.length(); ++j) {
                if (Character.isDigit(s.charAt(j))) continue;
                throw new ParseException("Status line contains invalid status code: " + buffer.substring(indexFrom, indexTo));
            }
            try {
                statusCode = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Status line contains invalid status code: " + buffer.substring(indexFrom, indexTo));
            }
            i = blank;
            String reasonPhrase = i < indexTo ? buffer.substringTrimmed(i, indexTo) : "";
            return this.createStatusLine(ver, statusCode, reasonPhrase);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Invalid status line: " + buffer.substring(indexFrom, indexTo));
        }
    }

    protected StatusLine createStatusLine(ProtocolVersion ver, int status2, String reason) {
        return new BasicStatusLine(ver, status2, reason);
    }

    @Override
    public Header parseHeader(CharArrayBuffer buffer) throws ParseException {
        return new BufferedHeader(buffer);
    }

    protected void skipWhitespace(CharArrayBuffer buffer, ParserCursor cursor) {
        int pos;
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && HTTP.isWhitespace(buffer.charAt(pos)); ++pos) {
        }
        cursor.updatePos(pos);
    }
}

