"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = void 0;
var colors_1 = require("../../../../common/colors");
exports.config = {
    width: 500,
    height: 500,
    margin: { left: 0.01, right: 0.01, top: 0.01, bottom: 0.01 },
    maxRowHeight: 30,
    maxColumnWidth: 30,
    fontFamily: 'Sans-Serif',
    brushArea: {
        visible: true,
        fill: colors_1.Colors.Black.keyword,
        stroke: '#69707D',
        strokeWidth: 2,
    },
    brushMask: {
        visible: true,
        fill: 'rgb(115 115 115 / 50%)',
    },
    brushTool: {
        visible: false,
        fill: 'gray',
    },
    timeZone: 'UTC',
    xAxisLabel: {
        name: 'X Value',
        visible: true,
        width: 'auto',
        fontSize: 12,
        fontFamily: 'Sans-Serif',
        fontStyle: 'normal',
        textColor: colors_1.Colors.Black.keyword,
        fontVariant: 'normal',
        fontWeight: 'normal',
        align: 'center',
        baseline: 'verticalAlign',
        padding: 6,
        formatter: String,
    },
    yAxisLabel: {
        name: 'Y Value',
        visible: true,
        width: 'auto',
        fontSize: 12,
        fontFamily: 'Sans-Serif',
        fontStyle: 'normal',
        textColor: colors_1.Colors.Black.keyword,
        fontVariant: 'normal',
        fontWeight: 'normal',
        baseline: 'verticalAlign',
        padding: 5,
        formatter: String,
    },
    grid: {
        cellWidth: {
            min: 0,
            max: 30,
        },
        cellHeight: {
            min: 12,
            max: 30,
        },
        stroke: {
            width: 1,
            color: 'gray',
        },
    },
    cell: {
        maxWidth: 'fill',
        maxHeight: 'fill',
        align: 'center',
        label: {
            visible: true,
            maxWidth: 'fill',
            minFontSize: 8,
            maxFontSize: 12,
            fontFamily: 'Sans-Serif',
            fontStyle: 'normal',
            textColor: colors_1.Colors.Black.keyword,
            fontVariant: 'normal',
            fontWeight: 'normal',
            useGlobalMinFontSize: true,
        },
        border: {
            strokeWidth: 1,
            stroke: 'gray',
        },
    },
};
//# sourceMappingURL=config.js.map