"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatStackedDataSeriesValues = exports.datumXSortPredicate = void 0;
var d3_shape_1 = require("d3-shape");
var constants_1 = require("../../../scales/constants");
var common_1 = require("../../../utils/common");
var specs_1 = require("./specs");
var datumXSortPredicate = function (xScaleType, sortedXValues) { return function (a, b) {
    if (xScaleType === constants_1.ScaleType.Ordinal || typeof a.x === 'string' || typeof b.x === 'string') {
        return sortedXValues ? sortedXValues.indexOf(a.x) - sortedXValues.indexOf(b.x) : 0;
    }
    return a.x - b.x;
}; };
exports.datumXSortPredicate = datumXSortPredicate;
function formatStackedDataSeriesValues(dataSeries, xValues, stackMode) {
    var dataSeriesKeys = dataSeries.reduce(function (acc, curr) {
        acc[curr.key] = curr;
        return acc;
    }, {});
    var xValuesArray = __spreadArray([], __read(xValues), false);
    var reorderedArray = [];
    var xValueMap = new Map();
    dataSeries.forEach(function (_a) {
        var data = _a.data, key = _a.key, isFiltered = _a.isFiltered;
        if (isFiltered) {
            return;
        }
        var dsMap = new Map();
        data.forEach(function (d) {
            var x = d.x, y0 = d.y0, y1 = d.y1;
            var xIndex = xValuesArray.indexOf(x);
            if (reorderedArray[xIndex] === undefined) {
                reorderedArray[xIndex] = { x: x };
            }
            reorderedArray[xIndex][key + "-y0"] = y0;
            reorderedArray[xIndex][key + "-y1"] = (y1 !== null && y1 !== void 0 ? y1 : 0) - (y0 !== null && y0 !== void 0 ? y0 : 0);
            dsMap.set(x, d);
        });
        xValueMap.set(key, dsMap);
    });
    var stackOffset = getOffsetBasedOnStackMode(stackMode);
    var keys = Object.keys(dataSeriesKeys).reduce(function (acc, key) { return __spreadArray(__spreadArray([], __read(acc), false), [key + "-y0", key + "-y1"], false); }, []);
    var stack = (0, d3_shape_1.stack)().keys(keys).order(d3_shape_1.stackOrderNone).offset(stackOffset)(reorderedArray);
    var unionedYStacks = stack.reduce(function (acc, d) {
        var key = d.key.slice(0, -3);
        var accessor = d.key.slice(-2);
        if (accessor !== 'y1' && accessor !== 'y0') {
            return acc;
        }
        if (!acc[key]) {
            acc[key] = {
                y0: [],
                y1: [],
            };
        }
        acc[key][accessor] = d.map(function (da) { return da; });
        return acc;
    }, {});
    return Object.keys(unionedYStacks).map(function (stackedDataSeriesKey) {
        var dataSeriesProps = dataSeriesKeys[stackedDataSeriesKey];
        var dsMap = xValueMap.get(stackedDataSeriesKey);
        var _a = unionedYStacks[stackedDataSeriesKey], y0StackArray = _a.y0, y1StackArray = _a.y1;
        var data = y1StackArray
            .map(function (y1Stack, index) {
            var x = y1Stack.data.x;
            if (x === undefined || x === null) {
                return null;
            }
            var originalData = dsMap === null || dsMap === void 0 ? void 0 : dsMap.get(x);
            if (!originalData) {
                return null;
            }
            var _a = __read(y0StackArray[index], 2), y0 = _a[1];
            var _b = __read(y1Stack, 2), y1 = _b[1];
            var initialY0 = originalData.initialY0, initialY1 = originalData.initialY1, mark = originalData.mark, datum = originalData.datum, filled = originalData.filled;
            return {
                x: x,
                y1: clampIfStackedAsPercentage(y1, stackMode),
                y0: clampIfStackedAsPercentage(y0, stackMode),
                initialY0: initialY0,
                initialY1: initialY1,
                mark: mark,
                datum: datum,
                filled: filled,
            };
        })
            .filter(function (d) { return d !== null; });
        return __assign(__assign({}, dataSeriesProps), { data: data });
    });
}
exports.formatStackedDataSeriesValues = formatStackedDataSeriesValues;
function clampIfStackedAsPercentage(value, stackMode) {
    return stackMode === specs_1.StackMode.Percentage ? (0, common_1.clamp)(value, 0, 1) : value;
}
function getOffsetBasedOnStackMode(stackMode) {
    switch (stackMode) {
        case specs_1.StackMode.Percentage:
            return d3_shape_1.stackOffsetExpand;
        case specs_1.StackMode.Silhouette:
            return d3_shape_1.stackOffsetSilhouette;
        case specs_1.StackMode.Wiggle:
            return d3_shape_1.stackOffsetWiggle;
        default:
            return d3_shape_1.stackOffsetNone;
    }
}
//# sourceMappingURL=stacked_series_utils.js.map