"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInitialPointerState = exports.isClicking = exports.getSpecsFromStore = void 0;
function getSpecsFromStore(specs, chartType, specType) {
    return Object.values(specs).filter(function (spec) { return spec.chartType === chartType && spec.specType === specType; });
}
exports.getSpecsFromStore = getSpecsFromStore;
function isClicking(prevClick, lastClick) {
    return lastClick && (!prevClick || prevClick.time !== lastClick.time);
}
exports.isClicking = isClicking;
var getInitialPointerState = function () { return ({
    dragging: false,
    current: { position: { x: -1, y: -1 }, time: 0 },
    down: null,
    up: null,
    lastDrag: null,
    lastClick: null,
}); };
exports.getInitialPointerState = getInitialPointerState;
//# sourceMappingURL=utils.js.map