"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _downshift = _interopRequireDefault(require("downshift"));

var _types = require("./types");

var _viewHelpers = require("./view-helpers");

var _Autocomplete = _interopRequireDefault(require("./Autocomplete"));

var _SearchInput = _interopRequireDefault(require("./SearchInput"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function SearchBox(props) {
  var className = props.className,
      allAutocompletedItemsCount = props.allAutocompletedItemsCount,
      autocompleteView = props.autocompleteView,
      isFocused = props.isFocused,
      _props$inputProps = props.inputProps,
      inputProps = _props$inputProps === void 0 ? {} : _props$inputProps,
      inputView = props.inputView,
      onChange = props.onChange,
      onSelectAutocomplete = props.onSelectAutocomplete,
      _onSubmit = props.onSubmit,
      useAutocomplete = props.useAutocomplete,
      value = props.value,
      autocompletedResults = props.autocompletedResults,
      autocompletedSuggestions = props.autocompletedSuggestions,
      autocompletedSuggestionsCount = props.autocompletedSuggestionsCount,
      completeSuggestion = props.completeSuggestion,
      notifyAutocompleteSelected = props.notifyAutocompleteSelected,
      rest = (0, _objectWithoutProperties2.default)(props, ["className", "allAutocompletedItemsCount", "autocompleteView", "isFocused", "inputProps", "inputView", "onChange", "onSelectAutocomplete", "onSubmit", "useAutocomplete", "value", "autocompletedResults", "autocompletedSuggestions", "autocompletedSuggestionsCount", "completeSuggestion", "notifyAutocompleteSelected"]);
  var focusedClass = isFocused ? "focus" : "";
  var AutocompleteView = autocompleteView || _Autocomplete.default;
  var InputView = inputView || _SearchInput.default;
  return /*#__PURE__*/_react.default.createElement(_downshift.default, (0, _extends2.default)({
    inputValue: value,
    onChange: onSelectAutocomplete,
    onInputValueChange: function onInputValueChange(newValue) {
      // To avoid over dispatching
      if (value === newValue) return;
      onChange(newValue);
    } // Because when a selection is made, we don't really want to change
    // the inputValue. This is supposed to be a "controlled" value, and when
    // this happens we lose control of it.
    ,
    itemToString: function itemToString() {
      return value;
    }
  }, rest), function (downshiftProps) {
    var closeMenu = downshiftProps.closeMenu,
        _getInputProps = downshiftProps.getInputProps,
        isOpen = downshiftProps.isOpen;
    var autocompleteClass = isOpen === true ? " autocomplete" : "";
    return /*#__PURE__*/_react.default.createElement("form", {
      onSubmit: function onSubmit(e) {
        closeMenu();

        _onSubmit(e);
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _viewHelpers.appendClassName)("sui-search-box", className) + autocompleteClass
    }, /*#__PURE__*/_react.default.createElement(InputView, (0, _extends2.default)({}, downshiftProps, {
      getInputProps: function getInputProps(additionalProps) {
        var _ref = additionalProps || {},
            className = _ref.className,
            rest = (0, _objectWithoutProperties2.default)(_ref, ["className"]);

        return _getInputProps(_objectSpread(_objectSpread({
          placeholder: "Search"
        }, inputProps), {}, {
          className: (0, _viewHelpers.appendClassName)("sui-search-box__text-input", [inputProps.className, className, focusedClass])
        }, rest));
      },
      getButtonProps: function getButtonProps(additionalProps) {
        var _ref2 = additionalProps || {},
            className = _ref2.className,
            rest = (0, _objectWithoutProperties2.default)(_ref2, ["className"]);

        return _objectSpread({
          type: "submit",
          value: "Search",
          className: (0, _viewHelpers.appendClassName)("button sui-search-box__submit", className)
        }, rest);
      },
      getAutocomplete: function getAutocomplete() {
        if (useAutocomplete && isOpen && allAutocompletedItemsCount > 0) {
          return /*#__PURE__*/_react.default.createElement(AutocompleteView, (0, _extends2.default)({}, props, downshiftProps));
        } else {
          return null;
        }
      }
    }))));
  });
}

SearchBox.propTypes = {
  // Provided by container
  allAutocompletedItemsCount: _propTypes.default.number.isRequired,
  autocompletedResults: _propTypes.default.arrayOf(_types.Result).isRequired,
  autocompletedSuggestions: _propTypes.default.objectOf(_propTypes.default.arrayOf(_types.Suggestion)).isRequired,
  autocompletedSuggestionsCount: _propTypes.default.number.isRequired,
  completeSuggestion: _propTypes.default.func.isRequired,
  notifyAutocompleteSelected: _propTypes.default.func.isRequired,
  onChange: _propTypes.default.func.isRequired,
  onSubmit: _propTypes.default.func.isRequired,
  value: _propTypes.default.string.isRequired,
  autocompleteResults: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.shape({
    titleField: _propTypes.default.string.isRequired,
    urlField: _propTypes.default.string.isRequired,
    linkTarget: _propTypes.default.string,
    sectionTitle: _propTypes.default.string
  })]),
  autocompleteView: _propTypes.default.func,
  autocompleteSuggestions: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.exact({
    sectionTitle: _propTypes.default.string
  }), _propTypes.default.objectOf(_propTypes.default.exact({
    sectionTitle: _propTypes.default.string
  }))]),
  className: _propTypes.default.string,
  inputProps: _propTypes.default.object,
  inputView: _propTypes.default.func,
  isFocused: _propTypes.default.bool,
  useAutocomplete: _propTypes.default.bool,
  // Specific configuration for this view only
  onSelectAutocomplete: _propTypes.default.func
};
var _default = SearchBox;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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