import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import URLManager from "./URLManager";
import RequestSequencer from "./RequestSequencer";
import DebounceManager from "./DebounceManager";
import * as actions from "./actions";
import Events from "./Events";
import { mergeFilters } from "./helpers";
import * as a11y from "./A11yNotifications";

function filterSearchParameters(_ref) {
  var current = _ref.current,
      filters = _ref.filters,
      resultsPerPage = _ref.resultsPerPage,
      searchTerm = _ref.searchTerm,
      sortDirection = _ref.sortDirection,
      sortField = _ref.sortField;
  return {
    current: current,
    filters: filters,
    resultsPerPage: resultsPerPage,
    searchTerm: searchTerm,
    sortDirection: sortDirection,
    sortField: sortField
  };
}

export var DEFAULT_STATE = {
  // Search Parameters -- This is state that represents the input state.
  current: 1,
  filters: [],
  resultsPerPage: 20,
  searchTerm: "",
  sortDirection: "",
  sortField: "",
  // Result State -- This state represents state that is updated automatically
  // as the result of changing input state.
  autocompletedResults: [],
  autocompletedResultsRequestId: "",
  autocompletedSuggestions: {},
  autocompletedSuggestionsRequestId: "",
  error: "",
  isLoading: false,
  facets: {},
  requestId: "",
  results: [],
  resultSearchTerm: "",
  totalPages: 0,
  totalResults: 0,
  pagingStart: 0,
  pagingEnd: 0,
  wasSearched: false,
  rawResponse: {}
};

function removeConditionalFacets() {
  var facets = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var conditionalFacets = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var filters = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  return Object.entries(facets).reduce(function (acc, _ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        facetKey = _ref3[0],
        facet = _ref3[1];

    if (conditionalFacets[facetKey] && typeof conditionalFacets[facetKey] === "function" && !conditionalFacets[facetKey]({
      filters: filters
    })) {
      return acc;
    }

    acc[facetKey] = facet;
    return acc;
  }, {});
}
/*
 * The Driver is a framework agnostic search state manager that is capable
 * syncing state to the url.
 */


var SearchDriver = /*#__PURE__*/function () {
  function SearchDriver(_ref4) {
    var _this = this;

    var apiConnector = _ref4.apiConnector,
        _ref4$autocompleteQue = _ref4.autocompleteQuery,
        autocompleteQuery = _ref4$autocompleteQue === void 0 ? {} : _ref4$autocompleteQue,
        debug = _ref4.debug,
        initialState = _ref4.initialState,
        onSearch = _ref4.onSearch,
        onAutocomplete = _ref4.onAutocomplete,
        onResultClick = _ref4.onResultClick,
        onAutocompleteResultClick = _ref4.onAutocompleteResultClick,
        _ref4$searchQuery = _ref4.searchQuery,
        searchQuery = _ref4$searchQuery === void 0 ? {} : _ref4$searchQuery,
        _ref4$trackUrlState = _ref4.trackUrlState,
        trackUrlState = _ref4$trackUrlState === void 0 ? true : _ref4$trackUrlState,
        _ref4$urlPushDebounce = _ref4.urlPushDebounceLength,
        urlPushDebounceLength = _ref4$urlPushDebounce === void 0 ? 500 : _ref4$urlPushDebounce,
        _ref4$hasA11yNotifica = _ref4.hasA11yNotifications,
        hasA11yNotifications = _ref4$hasA11yNotifica === void 0 ? false : _ref4$hasA11yNotifica,
        _ref4$a11yNotificatio = _ref4.a11yNotificationMessages,
        a11yNotificationMessages = _ref4$a11yNotificatio === void 0 ? {} : _ref4$a11yNotificatio,
        _ref4$alwaysSearchOnI = _ref4.alwaysSearchOnInitialLoad,
        alwaysSearchOnInitialLoad = _ref4$alwaysSearchOnI === void 0 ? false : _ref4$alwaysSearchOnI;

    _classCallCheck(this, SearchDriver);

    _defineProperty(this, "state", DEFAULT_STATE);

    _defineProperty(this, "_updateAutocomplete", function (searchTerm) {
      var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          autocompleteResults = _ref5.autocompleteResults,
          autocompleteSuggestions = _ref5.autocompleteSuggestions;

      var requestId = _this.autocompleteRequestSequencer.next();

      var queryConfig = _objectSpread(_objectSpread({}, autocompleteResults && {
        results: _this.autocompleteQuery.results || {}
      }), autocompleteSuggestions && {
        suggestions: _this.autocompleteQuery.suggestions || {}
      });

      return _this.events.autocomplete({
        searchTerm: searchTerm
      }, queryConfig).then(function (autocompleted) {
        if (_this.autocompleteRequestSequencer.isOldRequest(requestId)) return;

        _this.autocompleteRequestSequencer.completed(requestId);

        _this._setState(autocompleted);
      });
    });

    _defineProperty(this, "_updateSearchResults", function (searchParameters) {
      var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref6$skipPushToUrl = _ref6.skipPushToUrl,
          skipPushToUrl = _ref6$skipPushToUrl === void 0 ? false : _ref6$skipPushToUrl,
          _ref6$replaceUrl = _ref6.replaceUrl,
          replaceUrl = _ref6$replaceUrl === void 0 ? false : _ref6$replaceUrl;

      var _this$state$searchPar = _objectSpread(_objectSpread({}, _this.state), searchParameters),
          current = _this$state$searchPar.current,
          filters = _this$state$searchPar.filters,
          resultsPerPage = _this$state$searchPar.resultsPerPage,
          searchTerm = _this$state$searchPar.searchTerm,
          sortDirection = _this$state$searchPar.sortDirection,
          sortField = _this$state$searchPar.sortField; // State updates should always be applied in the order that they are made. This function, _updateSearchResults,
      // makes state updates.
      // In the case where a call to "_updateSearchResults" was made and delayed for X amount of time using
      // `debounceManager.runWithDebounce`, and a subsequent call is made _updateSearchResults before that delay ends, we
      // want to make sure that outstanding call to "_updateSearchResults" is cancelled, as it would apply state updates
      // out of order.


      _this.debounceManager.cancelByName("_updateSearchResults");

      _this._setState({
        current: current,
        error: "",
        filters: filters,
        resultsPerPage: resultsPerPage,
        searchTerm: searchTerm,
        sortDirection: sortDirection,
        sortField: sortField
      });

      _this._makeSearchRequest({
        skipPushToUrl: skipPushToUrl,
        replaceUrl: replaceUrl
      });
    });

    _defineProperty(this, "_makeSearchRequest", DebounceManager.debounce(0, function (_ref7) {
      var skipPushToUrl = _ref7.skipPushToUrl,
          replaceUrl = _ref7.replaceUrl;
      var _this$state = _this.state,
          current = _this$state.current,
          filters = _this$state.filters,
          resultsPerPage = _this$state.resultsPerPage,
          searchTerm = _this$state.searchTerm,
          sortDirection = _this$state.sortDirection,
          sortField = _this$state.sortField;

      _this._setState({
        isLoading: true
      });

      var requestId = _this.searchRequestSequencer.next();

      var _this$searchQuery = _this.searchQuery,
          searchQueryFilters = _this$searchQuery.filters,
          conditionalFacets = _this$searchQuery.conditionalFacets,
          restOfSearchQuery = _objectWithoutProperties(_this$searchQuery, ["filters", "conditionalFacets"]);

      var queryConfig = _objectSpread(_objectSpread({}, restOfSearchQuery), {}, {
        facets: removeConditionalFacets(_this.searchQuery.facets, conditionalFacets, filters)
      });

      var requestState = _objectSpread(_objectSpread({}, filterSearchParameters(_this.state)), {}, {
        filters: mergeFilters(filters, _this.searchQuery.filters)
      });

      return _this.events.search(requestState, queryConfig).then(function (resultState) {
        if (_this.searchRequestSequencer.isOldRequest(requestId)) return;

        _this.searchRequestSequencer.completed(requestId); // Results paging start & end


        var totalResults = resultState.totalResults;
        var start = totalResults === 0 ? 0 : (current - 1) * resultsPerPage + 1;
        var end = totalResults <= start + resultsPerPage ? totalResults : start + resultsPerPage - 1;

        _this._setState(_objectSpread(_objectSpread({
          isLoading: false,
          resultSearchTerm: searchTerm,
          pagingStart: start,
          pagingEnd: end
        }, resultState), {}, {
          wasSearched: true
        }));

        if (_this.hasA11yNotifications) {
          var messageArgs = {
            start: start,
            end: end,
            totalResults: totalResults,
            searchTerm: searchTerm
          };

          _this.actions.a11yNotify("searchResults", messageArgs);
        }

        if (!skipPushToUrl && _this.trackUrlState) {
          // We debounce here so that we don't get a lot of intermediary
          // URL state if someone is updating a UI really fast, like typing
          // in a live search box for instance.
          _this.debounceManager.runWithDebounce(_this.urlPushDebounceLength, "pushStateToURL", _this.URLManager.pushStateToURL.bind(_this.URLManager), {
            current: current,
            filters: filters,
            resultsPerPage: resultsPerPage,
            searchTerm: searchTerm,
            sortDirection: sortDirection,
            sortField: sortField
          }, {
            replaceUrl: replaceUrl
          });
        }
      }, function (error) {
        _this._setState({
          error: "An unexpected error occurred: ".concat(error.message)
        });
      });
    }));

    this.actions = Object.entries(actions).reduce(function (acc, _ref8) {
      var _ref9 = _slicedToArray(_ref8, 2),
          actionName = _ref9[0],
          action = _ref9[1];

      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, actionName, action.bind(_this)));
    }, {});
    Object.assign(this, this.actions);
    this.events = new Events({
      apiConnector: apiConnector,
      onSearch: onSearch,
      onAutocomplete: onAutocomplete,
      onResultClick: onResultClick,
      onAutocompleteResultClick: onAutocompleteResultClick
    });
    this.debug = debug;

    if (this.debug) {
      console.warn("Search UI Debugging is enabled. This should be turned off in production deployments.");
      window.searchUI = this;
    }

    this.autocompleteRequestSequencer = new RequestSequencer();
    this.searchRequestSequencer = new RequestSequencer();
    this.debounceManager = new DebounceManager();
    this.autocompleteQuery = autocompleteQuery;
    this.searchQuery = searchQuery;
    this.subscriptions = [];
    this.trackUrlState = trackUrlState;
    this.urlPushDebounceLength = urlPushDebounceLength;
    this.alwaysSearchOnInitialLoad = alwaysSearchOnInitialLoad;
    var urlState;

    if (trackUrlState) {
      this.URLManager = new URLManager();
      urlState = this.URLManager.getStateFromURL();
      this.URLManager.onURLStateChange(function (urlState) {
        _this._updateSearchResults(_objectSpread(_objectSpread({}, DEFAULT_STATE), urlState), {
          skipPushToUrl: true
        });
      });
    } else {
      urlState = {};
    } // Manage screen reader accessible notifications


    this.hasA11yNotifications = hasA11yNotifications;
    if (this.hasA11yNotifications) a11y.getLiveRegion();
    this.a11yNotificationMessages = _objectSpread(_objectSpread({}, a11y.defaultMessages), a11yNotificationMessages); // Remember the state this application is initialized into, so that we can
    // reset to it later.

    this.startingState = _objectSpread(_objectSpread({}, this.state), initialState); // We filter these here to disallow anything other than valid search
    // parameters to be passed in initial state, or url state. `results`, etc,
    // should not be allowed to be passed in, that should be generated based on
    // the results of the query

    var _searchParameters = filterSearchParameters(_objectSpread(_objectSpread({}, this.startingState), urlState)); // Initialize the state without calling _setState, because we don't
    // want to trigger an update callback, we're just initializing the state
    // to the correct default values for the initial UI render


    this.state = _objectSpread(_objectSpread({}, this.state), _searchParameters); // We'll trigger an initial search if initial parameters contain
    // a search term or filters, or if alwaysSearchOnInitialLoad is set.
    // Otherwise, we'll just save their selections in state as initial values.

    if (_searchParameters.searchTerm || _searchParameters.filters.length > 0 || this.alwaysSearchOnInitialLoad) {
      this._updateSearchResults(_searchParameters, {
        replaceUrl: true
      });
    }
  }
  /**
   * This method is used to update state and trigger a new autocomplete search.
   *
   * @param {string} searchTerm
   * @param {Object=} Object
   * @param {boolean|Object} options.autocompleteResults - Should autocomplete results
   * @param {boolean|Object} options.autocompleteSuggestions - Should autocomplete suggestions
   */


  _createClass(SearchDriver, [{
    key: "_setState",
    value: function _setState(newState) {
      var state = _objectSpread(_objectSpread({}, this.state), newState); // eslint-disable-next-line no-console


      if (this.debug) console.log("Search UI: State Update", newState, state);
      this.state = state;
      this.subscriptions.forEach(function (subscription) {
        return subscription(state);
      });
    }
    /**
     * Dynamically update the searchQuery configuration in this driver.
     * This will issue a new query after being updated.
     *
     * @param Object searchQuery
     */

  }, {
    key: "setSearchQuery",
    value: function setSearchQuery(searchQuery) {
      this.searchQuery = searchQuery;

      this._updateSearchResults();
    }
    /**
     * @param Object autocompleteQuery
     */

  }, {
    key: "setAutocompleteQuery",
    value: function setAutocompleteQuery(autocompleteQuery) {
      this.autocompleteQuery = autocompleteQuery;
    }
    /**
     * Any time state is updated in this Driver, the provided callback
     * will be executed with the updated state.
     *
     * @param onStateChange Function
     */

  }, {
    key: "subscribeToStateChanges",
    value: function subscribeToStateChanges(onStateChange) {
      this.subscriptions.push(onStateChange);
    }
    /**
     * @param onStateChange Function
     */

  }, {
    key: "unsubscribeToStateChanges",
    value: function unsubscribeToStateChanges(onStateChange) {
      this.subscriptions = this.subscriptions.filter(function (sub) {
        return sub !== onStateChange;
      });
    }
    /**
     * Remove all listeners
     */

  }, {
    key: "tearDown",
    value: function tearDown() {
      this.subscriptions = [];
      this.URLManager && this.URLManager.tearDown();
    }
    /**
     * Retrieves all available acitons
     *
     * @returns Object All actions
     */

  }, {
    key: "getActions",
    value: function getActions() {
      return this.actions;
    }
    /**
     * Retrieve current state. Typically used on app initialization. Subsequent
     * state updates should come through subscription.
     *
     * @returns Object Current state
     */

  }, {
    key: "getState",
    value: function getState() {
      // We return a copy of state here, because we want to ensure the state
      // inside of this object remains immutable.
      return _objectSpread({}, this.state);
    }
  }]);

  return SearchDriver;
}();

export { SearchDriver as default };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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