/**
 * Report a click through event. A click through event is when a user
 * clicks on a result link.
 *
 * @param documentId String The document ID associated with result that was
 * clicked
 * @param tag Array[String] Optional Tags which can be used to categorize
 * this click event
 */
export default function trackClickThrough(documentId) {
  var _console;

  var tags = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "trackClickThrough"].concat(Array.prototype.slice.call(arguments)));
  var _this$state = this.state,
      requestId = _this$state.requestId,
      searchTerm = _this$state.searchTerm;
  this.events.resultClick({
    query: searchTerm,
    documentId: documentId,
    requestId: requestId,
    tags: tags
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL3RyYWNrQ2xpY2tUaHJvdWdoLmpzIl0sIm5hbWVzIjpbInRyYWNrQ2xpY2tUaHJvdWdoIiwiZG9jdW1lbnRJZCIsInRhZ3MiLCJkZWJ1ZyIsImNvbnNvbGUiLCJsb2ciLCJhcmd1bWVudHMiLCJzdGF0ZSIsInJlcXVlc3RJZCIsInNlYXJjaFRlcm0iLCJldmVudHMiLCJyZXN1bHRDbGljayIsInF1ZXJ5Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxlQUFlLFNBQVNBLGlCQUFULENBQTJCQyxVQUEzQixFQUFrRDtBQUFBOztBQUFBLE1BQVhDLElBQVcsdUVBQUosRUFBSTtBQUMvRCxNQUFJLEtBQUtDLEtBQVQsRUFDRTtBQUNBLGdCQUFBQyxPQUFPLEVBQUNDLEdBQVIsa0JBQVksbUJBQVosRUFBaUMsbUJBQWpDLG9DQUF5REMsU0FBekQ7QUFINkQsb0JBSzdCLEtBQUtDLEtBTHdCO0FBQUEsTUFLdkRDLFNBTHVELGVBS3ZEQSxTQUx1RDtBQUFBLE1BSzVDQyxVQUw0QyxlQUs1Q0EsVUFMNEM7QUFPL0QsT0FBS0MsTUFBTCxDQUFZQyxXQUFaLENBQXdCO0FBQ3RCQyxJQUFBQSxLQUFLLEVBQUVILFVBRGU7QUFFdEJSLElBQUFBLFVBQVUsRUFBVkEsVUFGc0I7QUFHdEJPLElBQUFBLFNBQVMsRUFBVEEsU0FIc0I7QUFJdEJOLElBQUFBLElBQUksRUFBSkE7QUFKc0IsR0FBeEI7QUFNRCIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogUmVwb3J0IGEgY2xpY2sgdGhyb3VnaCBldmVudC4gQSBjbGljayB0aHJvdWdoIGV2ZW50IGlzIHdoZW4gYSB1c2VyXG4gKiBjbGlja3Mgb24gYSByZXN1bHQgbGluay5cbiAqXG4gKiBAcGFyYW0gZG9jdW1lbnRJZCBTdHJpbmcgVGhlIGRvY3VtZW50IElEIGFzc29jaWF0ZWQgd2l0aCByZXN1bHQgdGhhdCB3YXNcbiAqIGNsaWNrZWRcbiAqIEBwYXJhbSB0YWcgQXJyYXlbU3RyaW5nXSBPcHRpb25hbCBUYWdzIHdoaWNoIGNhbiBiZSB1c2VkIHRvIGNhdGVnb3JpemVcbiAqIHRoaXMgY2xpY2sgZXZlbnRcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gdHJhY2tDbGlja1Rocm91Z2goZG9jdW1lbnRJZCwgdGFncyA9IFtdKSB7XG4gIGlmICh0aGlzLmRlYnVnKVxuICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1jb25zb2xlXG4gICAgY29uc29sZS5sb2coXCJTZWFyY2ggVUk6IEFjdGlvblwiLCBcInRyYWNrQ2xpY2tUaHJvdWdoXCIsIC4uLmFyZ3VtZW50cyk7XG5cbiAgY29uc3QgeyByZXF1ZXN0SWQsIHNlYXJjaFRlcm0gfSA9IHRoaXMuc3RhdGU7XG5cbiAgdGhpcy5ldmVudHMucmVzdWx0Q2xpY2soe1xuICAgIHF1ZXJ5OiBzZWFyY2hUZXJtLFxuICAgIGRvY3VtZW50SWQsXG4gICAgcmVxdWVzdElkLFxuICAgIHRhZ3NcbiAgfSk7XG59XG4iXX0=