"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoggingConfiguration = getLoggingConfiguration;

var _lodash = _interopRequireDefault(require("lodash"));

var _log_reporter = require("./log_reporter");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns the `@hapi/good` plugin configuration to be used for the legacy logging
 * @param config
 */
function getLoggingConfiguration(config, opsInterval) {
  const events = config.events;

  if (config.silent) {
    _lodash.default.defaults(events, {});
  } else if (config.quiet) {
    _lodash.default.defaults(events, {
      log: ['listening', 'error', 'fatal'],
      request: ['error'],
      error: '*'
    });
  } else if (config.verbose) {
    _lodash.default.defaults(events, {
      error: '*',
      log: '*',
      // To avoid duplicate logs, we explicitly disable these in verbose
      // mode as they are already provided by the new logging config under
      // the `http.server.response` and `metrics.ops` contexts.
      ops: '!',
      request: '!',
      response: '!'
    });
  } else {
    _lodash.default.defaults(events, {
      log: ['info', 'warning', 'error', 'fatal'],
      response: config.json ? '*' : '!',
      request: ['info', 'warning', 'error', 'fatal'],
      error: '*'
    });
  }

  const loggerStream = (0, _log_reporter.getLogReporter)({
    config: {
      json: config.json,
      dest: config.dest,
      timezone: config.timezone,
      // I'm adding the default here because if you add another filter
      // using the commandline it will remove authorization. I want users
      // to have to explicitly set --logging.filter.authorization=none or
      // --logging.filter.cookie=none to have it show up in the logs.
      filter: _lodash.default.defaults(config.filter, {
        authorization: 'remove',
        cookie: 'remove'
      })
    },
    events: _lodash.default.transform(events, function (filtered, val, key) {
      // provide a string compatible way to remove events
      if (val !== '!') filtered[key] = val;
    }, {})
  });
  const options = {
    ops: {
      interval: opsInterval
    },
    includes: {
      request: ['headers', 'payload'],
      response: ['headers', 'payload']
    },
    reporters: {
      logReporter: [loggerStream]
    }
  };
  return options;
}