"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRouter = createRouter;

var _Either = require("fp-ts/lib/Either");

var _PathReporter = require("io-ts/lib/PathReporter");

var _reactRouterConfig = require("react-router-config");

var _queryString = _interopRequireDefault(require("query-string"));

var _lodash = require("lodash");

var _merge_rt = require("@kbn/io-ts-utils/merge_rt");

var _deep_exact_rt = require("@kbn/io-ts-utils/deep_exact_rt");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function toReactRouterPath(path) {
  return path.replace(/(?:{([^\/]+)})/g, ':$1');
}

function createRouter(routes) {
  const routesByReactRouterConfig = new Map();
  const reactRouterConfigsByRoute = new Map();
  const reactRouterConfigs = routes.map(route => toReactRouterConfigRoute(route));

  function toReactRouterConfigRoute(route) {
    var _map, _route$children, _route$children2;

    const reactRouterConfig = {
      component: () => route.element,
      routes: (_map = (_route$children = route.children) === null || _route$children === void 0 ? void 0 : _route$children.map(child => toReactRouterConfigRoute(child))) !== null && _map !== void 0 ? _map : [],
      exact: !((_route$children2 = route.children) !== null && _route$children2 !== void 0 && _route$children2.length),
      path: toReactRouterPath(route.path)
    };
    routesByReactRouterConfig.set(reactRouterConfig, route);
    reactRouterConfigsByRoute.set(route, reactRouterConfig);
    return reactRouterConfig;
  }

  function getRoutesToMatch(path) {
    const matches = (0, _reactRouterConfig.matchRoutes)(reactRouterConfigs, toReactRouterPath(path));

    if (!matches.length) {
      throw new Error(`No matching route found for ${path}`);
    }

    const matchedRoutes = matches.map(match => {
      return routesByReactRouterConfig.get(match.route);
    });
    return matchedRoutes;
  }

  const matchRoutes = (...args) => {
    let optional = false;

    if (typeof args[args.length - 1] === 'boolean') {
      optional = args[args.length - 1];
      args.pop();
    }

    const location = args[args.length - 1];
    args.pop();
    let paths = args;

    if (paths.length === 0) {
      paths = [location.pathname || '/'];
    }

    let matches = [];
    let matchIndex = -1;

    for (const path of paths) {
      const greedy = path.endsWith('/*') || args.length === 0;
      matches = (0, _reactRouterConfig.matchRoutes)(reactRouterConfigs, toReactRouterPath(location.pathname));
      matchIndex = greedy ? matches.length - 1 : (0, _lodash.findLastIndex)(matches, match => match.route.path === toReactRouterPath(path));

      if (matchIndex !== -1) {
        break;
      }

      matchIndex = -1;
    }

    if (matchIndex === -1) {
      if (optional) {
        return [];
      }

      throw new Error(`No matching route found for ${paths}`);
    }

    return matches.slice(0, matchIndex + 1).map(matchedRoute => {
      const route = routesByReactRouterConfig.get(matchedRoute.route);

      if (route !== null && route !== void 0 && route.params) {
        var _route$defaults;

        const decoded = (0, _deep_exact_rt.deepExactRt)(route.params).decode((0, _lodash.merge)({}, (_route$defaults = route.defaults) !== null && _route$defaults !== void 0 ? _route$defaults : {}, {
          path: matchedRoute.match.params,
          query: _queryString.default.parse(location.search, {
            decode: true
          })
        }));

        if ((0, _Either.isLeft)(decoded)) {
          throw new Error(_PathReporter.PathReporter.report(decoded).join('\n'));
        }

        return {
          match: { ...matchedRoute.match,
            params: decoded.right
          },
          route
        };
      }

      return {
        match: { ...matchedRoute.match,
          params: {
            path: {},
            query: {}
          }
        },
        route
      };
    });
  };

  const link = (path, ...args) => {
    const params = args[0];
    const paramsWithBuiltInDefaults = (0, _lodash.merge)({
      path: {},
      query: {}
    }, params);
    path = path.split('/').map(part => {
      const match = part.match(/(?:{([a-zA-Z]+)})/);
      return match ? paramsWithBuiltInDefaults.path[match[1]] : part;
    }).join('/');
    const matchedRoutes = getRoutesToMatch(path);
    const validationType = (0, _merge_rt.mergeRt)(...(0, _lodash.compact)(matchedRoutes.map(match => {
      return match.params;
    })));
    const paramsWithRouteDefaults = (0, _lodash.merge)({}, ...matchedRoutes.map(route => {
      var _route$defaults2;

      return (_route$defaults2 = route.defaults) !== null && _route$defaults2 !== void 0 ? _route$defaults2 : {};
    }), paramsWithBuiltInDefaults);
    const validation = validationType.decode(paramsWithRouteDefaults);

    if ((0, _Either.isLeft)(validation)) {
      throw new Error(_PathReporter.PathReporter.report(validation).join('\n'));
    }

    return _queryString.default.stringifyUrl({
      url: path,
      query: paramsWithRouteDefaults.query
    }, {
      encode: true
    });
  };

  return {
    link: (path, ...args) => {
      return link(path, ...args);
    },
    getParams: (...args) => {
      const matches = matchRoutes(...args);
      return matches.length ? (0, _lodash.merge)({
        path: {},
        query: {}
      }, ...matches.map(match => {
        var _match$route$defaults, _match$route;

        return (0, _lodash.merge)({}, (_match$route$defaults = (_match$route = match.route) === null || _match$route === void 0 ? void 0 : _match$route.defaults) !== null && _match$route$defaults !== void 0 ? _match$route$defaults : {}, match.match.params);
      })) : undefined;
    },
    matchRoutes: (...args) => {
      return matchRoutes(...args);
    },
    getRoutePath: route => {
      return reactRouterConfigsByRoute.get(route).path;
    },
    getRoutesToMatch: path => {
      return getRoutesToMatch(path);
    }
  };
}