"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRoutePath = useRoutePath;

var _lodash = require("lodash");

var _use_match_routes = require("./use_match_routes");

var _use_router = require("./use_router");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function useRoutePath() {
  const lastRouteMatch = (0, _lodash.last)((0, _use_match_routes.useMatchRoutes)());
  const router = (0, _use_router.useRouter)();

  if (!lastRouteMatch) {
    throw new Error('No route was matched');
  }

  return router.getRoutePath(lastRouteMatch.route);
}