"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGridLineForHorizontalAxisAt = exports.getGridLineForVerticalAxisAt = exports.getGridLinesForSpec = exports.getGridLines = void 0;
var color_library_wrappers_1 = require("../../../common/color_library_wrappers");
var common_1 = require("../../../utils/common");
var line_1 = require("../renderer/canvas/primitives/line");
var axis_type_utils_1 = require("./axis_type_utils");
var panel_1 = require("./panel");
var panel_utils_1 = require("./panel_utils");
function getGridLines(axesSpecs, axesGeoms, _a, scales) {
    var themeAxisStyle = _a.axes;
    var panelSize = (0, panel_1.getPanelSize)(scales);
    return (0, panel_utils_1.getPerPanelMap)(scales, function () {
        var lines = axesGeoms.reduce(function (linesAcc, _a) {
            var axis = _a.axis, visibleTicks = _a.visibleTicks;
            var axisSpec = axesSpecs.find(function (_a) {
                var id = _a.id;
                return id === axis.id;
            });
            if (!axisSpec) {
                return linesAcc;
            }
            var linesForSpec = getGridLinesForSpec(axisSpec, visibleTicks, themeAxisStyle, panelSize);
            if (!linesForSpec) {
                return linesAcc;
            }
            return __spreadArray(__spreadArray([], __read(linesAcc), false), [linesForSpec], false);
        }, []);
        return { lineGroups: lines };
    });
}
exports.getGridLines = getGridLines;
function getGridLinesForSpec(axisSpec, visibleTicks, themeAxisStyle, panelSize) {
    var _a;
    var isVertical = (0, axis_type_utils_1.isVerticalAxis)(axisSpec.position);
    var axisStyle = (0, common_1.mergePartial)(themeAxisStyle, axisSpec.style);
    var gridLineThemeStyle = isVertical ? axisStyle.gridLine.vertical : axisStyle.gridLine.horizontal;
    var gridLineStyles = axisSpec.gridLine ? (0, common_1.mergePartial)(gridLineThemeStyle, axisSpec.gridLine) : gridLineThemeStyle;
    var showGridLines = (_a = axisSpec.showGridLines) !== null && _a !== void 0 ? _a : gridLineStyles.visible;
    if (!showGridLines) {
        return null;
    }
    var lines = visibleTicks.map(function (tick) {
        return isVertical
            ? getGridLineForVerticalAxisAt(tick.position, panelSize)
            : getGridLineForHorizontalAxisAt(tick.position, panelSize);
    });
    if (!gridLineStyles.stroke || !gridLineStyles.strokeWidth || gridLineStyles.strokeWidth < line_1.MIN_STROKE_WIDTH) {
        return null;
    }
    var strokeColor = (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)(gridLineStyles.stroke), function (strokeColorOpacity) {
        return gridLineStyles.opacity !== undefined ? strokeColorOpacity * gridLineStyles.opacity : strokeColorOpacity;
    });
    var stroke = {
        color: strokeColor,
        width: gridLineStyles.strokeWidth,
        dash: gridLineStyles.dash,
    };
    return {
        lines: lines,
        stroke: stroke,
        axisId: axisSpec.id,
    };
}
exports.getGridLinesForSpec = getGridLinesForSpec;
function getGridLineForVerticalAxisAt(tickPosition, panelSize) {
    return { x1: 0, y1: tickPosition, x2: panelSize.width, y2: tickPosition };
}
exports.getGridLineForVerticalAxisAt = getGridLineForVerticalAxisAt;
function getGridLineForHorizontalAxisAt(tickPosition, panelSize) {
    return { x1: tickPosition, y1: 0, x2: tickPosition, y2: panelSize.height };
}
exports.getGridLineForHorizontalAxisAt = getGridLineForHorizontalAxisAt;
//# sourceMappingURL=grid_lines.js.map