import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _regeneratorRuntime from "@babel/runtime/regenerator";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { chain, fromEither, tryCatch } from 'fp-ts/lib/TaskEither';
import { flow } from 'fp-ts/lib/function';
import { validateEither } from '@kbn/securitysolution-io-ts-utils';
import { createEndpointListSchema, exceptionListItemSchema, exceptionListSchema, foundExceptionListItemSchema, foundExceptionListSchema } from '@kbn/securitysolution-io-ts-list-types';
import { ENDPOINT_LIST_URL, EXCEPTION_LIST_ITEM_URL, EXCEPTION_LIST_NAMESPACE, EXCEPTION_LIST_NAMESPACE_AGNOSTIC, EXCEPTION_LIST_URL } from '@kbn/securitysolution-list-constants';
import { toError, toPromise } from '../fp_utils';
/**
 * Add new ExceptionList
 *
 * @param http Kibana http service
 * @param list exception list to add
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 *
 */

var addExceptionList = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var http, list, signal;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            http = _ref.http, list = _ref.list, signal = _ref.signal;
            return _context.abrupt("return", http.fetch(EXCEPTION_LIST_URL, {
              body: JSON.stringify(list),
              method: 'POST',
              signal: signal
            }));

          case 2:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function addExceptionList(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var addExceptionListWithValidation = /*#__PURE__*/function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_ref3) {
    var http, list, signal;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            http = _ref3.http, list = _ref3.list, signal = _ref3.signal;
            return _context2.abrupt("return", flow(function () {
              return tryCatch(function () {
                return addExceptionList({
                  http: http,
                  list: list,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));

  return function addExceptionListWithValidation(_x2) {
    return _ref4.apply(this, arguments);
  };
}();

export { addExceptionListWithValidation as addExceptionList };
/**
 * Add new ExceptionListItem
 *
 * @param http Kibana http service
 * @param listItem exception list item to add
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 *
 */

var addExceptionListItem = /*#__PURE__*/function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_ref5) {
    var http, listItem, signal;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            http = _ref5.http, listItem = _ref5.listItem, signal = _ref5.signal;
            return _context3.abrupt("return", http.fetch(EXCEPTION_LIST_ITEM_URL, {
              body: JSON.stringify(listItem),
              method: 'POST',
              signal: signal
            }));

          case 2:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));

  return function addExceptionListItem(_x3) {
    return _ref6.apply(this, arguments);
  };
}();

var addExceptionListItemWithValidation = /*#__PURE__*/function () {
  var _ref8 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(_ref7) {
    var http, listItem, signal;
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            http = _ref7.http, listItem = _ref7.listItem, signal = _ref7.signal;
            return _context4.abrupt("return", flow(function () {
              return tryCatch(function () {
                return addExceptionListItem({
                  http: http,
                  listItem: listItem,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListItemSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));

  return function addExceptionListItemWithValidation(_x4) {
    return _ref8.apply(this, arguments);
  };
}();

export { addExceptionListItemWithValidation as addExceptionListItem };
/**
 * Update existing ExceptionList
 *
 * @param http Kibana http service
 * @param list exception list to add
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 *
 */

var updateExceptionList = /*#__PURE__*/function () {
  var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(_ref9) {
    var http, list, signal;
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            http = _ref9.http, list = _ref9.list, signal = _ref9.signal;
            return _context5.abrupt("return", http.fetch(EXCEPTION_LIST_URL, {
              body: JSON.stringify(list),
              method: 'PUT',
              signal: signal
            }));

          case 2:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));

  return function updateExceptionList(_x5) {
    return _ref10.apply(this, arguments);
  };
}();

var updateExceptionListWithValidation = /*#__PURE__*/function () {
  var _ref12 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(_ref11) {
    var http, list, signal;
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            http = _ref11.http, list = _ref11.list, signal = _ref11.signal;
            return _context6.abrupt("return", flow(function () {
              return tryCatch(function () {
                return updateExceptionList({
                  http: http,
                  list: list,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  }));

  return function updateExceptionListWithValidation(_x6) {
    return _ref12.apply(this, arguments);
  };
}();

export { updateExceptionListWithValidation as updateExceptionList };
/**
 * Update existing ExceptionListItem
 *
 * @param http Kibana http service
 * @param listItem exception list item to add
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 *
 */

var updateExceptionListItem = /*#__PURE__*/function () {
  var _ref14 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(_ref13) {
    var http, listItem, signal;
    return _regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            http = _ref13.http, listItem = _ref13.listItem, signal = _ref13.signal;
            return _context7.abrupt("return", http.fetch(EXCEPTION_LIST_ITEM_URL, {
              body: JSON.stringify(listItem),
              method: 'PUT',
              signal: signal
            }));

          case 2:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7);
  }));

  return function updateExceptionListItem(_x7) {
    return _ref14.apply(this, arguments);
  };
}();

var updateExceptionListItemWithValidation = /*#__PURE__*/function () {
  var _ref16 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee8(_ref15) {
    var http, listItem, signal;
    return _regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            http = _ref15.http, listItem = _ref15.listItem, signal = _ref15.signal;
            return _context8.abrupt("return", flow(function () {
              return tryCatch(function () {
                return updateExceptionListItem({
                  http: http,
                  listItem: listItem,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListItemSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8);
  }));

  return function updateExceptionListItemWithValidation(_x8) {
    return _ref16.apply(this, arguments);
  };
}();

export { updateExceptionListItemWithValidation as updateExceptionListItem };
/**
 * Fetch all ExceptionLists (optionally by namespaceType)
 *
 * @param http Kibana http service
 * @param namespaceTypes ExceptionList namespace_types of lists to find
 * @param filters search bar filters
 * @param pagination optional
 * @param signal to cancel request
 *
 * @throws An error if request params or response is not OK
 */

var fetchExceptionLists = /*#__PURE__*/function () {
  var _ref18 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee9(_ref17) {
    var http, filters, namespaceTypes, pagination, signal, query;
    return _regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            http = _ref17.http, filters = _ref17.filters, namespaceTypes = _ref17.namespaceTypes, pagination = _ref17.pagination, signal = _ref17.signal;
            query = {
              filter: filters,
              namespace_type: namespaceTypes,
              page: pagination.page ? "".concat(pagination.page) : '1',
              per_page: pagination.perPage ? "".concat(pagination.perPage) : '20',
              sort_field: 'exception-list.created_at',
              sort_order: 'desc'
            };
            return _context9.abrupt("return", http.fetch("".concat(EXCEPTION_LIST_URL, "/_find"), {
              method: 'GET',
              query: query,
              signal: signal
            }));

          case 3:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  }));

  return function fetchExceptionLists(_x9) {
    return _ref18.apply(this, arguments);
  };
}();

var fetchExceptionListsWithValidation = /*#__PURE__*/function () {
  var _ref20 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee10(_ref19) {
    var filters, http, namespaceTypes, pagination, signal;
    return _regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            filters = _ref19.filters, http = _ref19.http, namespaceTypes = _ref19.namespaceTypes, pagination = _ref19.pagination, signal = _ref19.signal;
            return _context10.abrupt("return", flow(function () {
              return tryCatch(function () {
                return fetchExceptionLists({
                  filters: filters,
                  http: http,
                  namespaceTypes: namespaceTypes,
                  pagination: pagination,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(foundExceptionListSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10);
  }));

  return function fetchExceptionListsWithValidation(_x10) {
    return _ref20.apply(this, arguments);
  };
}();

export { fetchExceptionListsWithValidation as fetchExceptionLists };
/**
 * Fetch an ExceptionList by providing a ExceptionList ID
 *
 * @param http Kibana http service
 * @param id ExceptionList ID (not list_id)
 * @param namespaceType ExceptionList namespace_type
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */

var fetchExceptionListById = /*#__PURE__*/function () {
  var _ref22 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee11(_ref21) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee11$(_context11) {
      while (1) {
        switch (_context11.prev = _context11.next) {
          case 0:
            http = _ref21.http, id = _ref21.id, namespaceType = _ref21.namespaceType, signal = _ref21.signal;
            return _context11.abrupt("return", http.fetch(EXCEPTION_LIST_URL, {
              method: 'GET',
              query: {
                id: id,
                namespace_type: namespaceType
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context11.stop();
        }
      }
    }, _callee11);
  }));

  return function fetchExceptionListById(_x11) {
    return _ref22.apply(this, arguments);
  };
}();

var fetchExceptionListByIdWithValidation = /*#__PURE__*/function () {
  var _ref24 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee12(_ref23) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee12$(_context12) {
      while (1) {
        switch (_context12.prev = _context12.next) {
          case 0:
            http = _ref23.http, id = _ref23.id, namespaceType = _ref23.namespaceType, signal = _ref23.signal;
            return _context12.abrupt("return", flow(function () {
              return tryCatch(function () {
                return fetchExceptionListById({
                  http: http,
                  id: id,
                  namespaceType: namespaceType,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context12.stop();
        }
      }
    }, _callee12);
  }));

  return function fetchExceptionListByIdWithValidation(_x12) {
    return _ref24.apply(this, arguments);
  };
}();

export { fetchExceptionListByIdWithValidation as fetchExceptionListById };
/**
 * Fetch an ExceptionList's ExceptionItems by providing a ExceptionList list_id
 *
 * @param http Kibana http service
 * @param listIds ExceptionList list_ids (not ID)
 * @param namespaceTypes ExceptionList namespace_types
 * @param filterOptions optional - filter by field or tags
 * @param pagination optional
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */

var fetchExceptionListsItemsByListIds = /*#__PURE__*/function () {
  var _ref26 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee13(_ref25) {
    var http, listIds, namespaceTypes, filterOptions, pagination, signal, filters, query;
    return _regeneratorRuntime.wrap(function _callee13$(_context13) {
      while (1) {
        switch (_context13.prev = _context13.next) {
          case 0:
            http = _ref25.http, listIds = _ref25.listIds, namespaceTypes = _ref25.namespaceTypes, filterOptions = _ref25.filterOptions, pagination = _ref25.pagination, signal = _ref25.signal;
            filters = filterOptions.map(function (filter, index) {
              var namespace = namespaceTypes[index];
              var filterNamespace = namespace === 'agnostic' ? EXCEPTION_LIST_NAMESPACE_AGNOSTIC : EXCEPTION_LIST_NAMESPACE;
              var formattedFilters = [].concat(_toConsumableArray(filter.filter.length ? ["".concat(filterNamespace, ".attributes.entries.field:").concat(filter.filter, "*")] : []), _toConsumableArray(filter.tags.length ? filter.tags.map(function (t) {
                return "".concat(filterNamespace, ".attributes.tags:").concat(t);
              }) : []));
              return formattedFilters.join(' AND ');
            }).join(',');
            query = _objectSpread({
              list_id: listIds.join(','),
              namespace_type: namespaceTypes.join(','),
              page: pagination.page ? "".concat(pagination.page) : '1',
              per_page: pagination.perPage ? "".concat(pagination.perPage) : '20',
              sort_field: 'exception-list.created_at',
              sort_order: 'desc'
            }, filters.trim() !== '' ? {
              filter: filters
            } : {});
            return _context13.abrupt("return", http.fetch("".concat(EXCEPTION_LIST_ITEM_URL, "/_find"), {
              method: 'GET',
              query: query,
              signal: signal
            }));

          case 4:
          case "end":
            return _context13.stop();
        }
      }
    }, _callee13);
  }));

  return function fetchExceptionListsItemsByListIds(_x13) {
    return _ref26.apply(this, arguments);
  };
}();

var fetchExceptionListsItemsByListIdsWithValidation = /*#__PURE__*/function () {
  var _ref28 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee14(_ref27) {
    var filterOptions, http, listIds, namespaceTypes, pagination, signal;
    return _regeneratorRuntime.wrap(function _callee14$(_context14) {
      while (1) {
        switch (_context14.prev = _context14.next) {
          case 0:
            filterOptions = _ref27.filterOptions, http = _ref27.http, listIds = _ref27.listIds, namespaceTypes = _ref27.namespaceTypes, pagination = _ref27.pagination, signal = _ref27.signal;
            return _context14.abrupt("return", flow(function () {
              return tryCatch(function () {
                return fetchExceptionListsItemsByListIds({
                  filterOptions: filterOptions,
                  http: http,
                  listIds: listIds,
                  namespaceTypes: namespaceTypes,
                  pagination: pagination,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(foundExceptionListItemSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context14.stop();
        }
      }
    }, _callee14);
  }));

  return function fetchExceptionListsItemsByListIdsWithValidation(_x14) {
    return _ref28.apply(this, arguments);
  };
}();

export { fetchExceptionListsItemsByListIdsWithValidation as fetchExceptionListsItemsByListIds };
/**
 * Fetch an ExceptionListItem by providing a ExceptionListItem ID
 *
 * @param http Kibana http service
 * @param id ExceptionListItem ID (not item_id)
 * @param namespaceType ExceptionList namespace_type
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */

var fetchExceptionListItemById = /*#__PURE__*/function () {
  var _ref30 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee15(_ref29) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee15$(_context15) {
      while (1) {
        switch (_context15.prev = _context15.next) {
          case 0:
            http = _ref29.http, id = _ref29.id, namespaceType = _ref29.namespaceType, signal = _ref29.signal;
            return _context15.abrupt("return", http.fetch(EXCEPTION_LIST_ITEM_URL, {
              method: 'GET',
              query: {
                id: id,
                namespace_type: namespaceType
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context15.stop();
        }
      }
    }, _callee15);
  }));

  return function fetchExceptionListItemById(_x15) {
    return _ref30.apply(this, arguments);
  };
}();

var fetchExceptionListItemByIdWithValidation = /*#__PURE__*/function () {
  var _ref32 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee16(_ref31) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee16$(_context16) {
      while (1) {
        switch (_context16.prev = _context16.next) {
          case 0:
            http = _ref31.http, id = _ref31.id, namespaceType = _ref31.namespaceType, signal = _ref31.signal;
            return _context16.abrupt("return", flow(function () {
              return tryCatch(function () {
                return fetchExceptionListItemById({
                  http: http,
                  id: id,
                  namespaceType: namespaceType,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListItemSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context16.stop();
        }
      }
    }, _callee16);
  }));

  return function fetchExceptionListItemByIdWithValidation(_x16) {
    return _ref32.apply(this, arguments);
  };
}();

export { fetchExceptionListItemByIdWithValidation as fetchExceptionListItemById };
/**
 * Delete an ExceptionList by providing a ExceptionList ID
 *
 * @param http Kibana http service
 * @param id ExceptionList ID (not list_id)
 * @param namespaceType ExceptionList namespace_type
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */

var deleteExceptionListById = /*#__PURE__*/function () {
  var _ref34 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee17(_ref33) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee17$(_context17) {
      while (1) {
        switch (_context17.prev = _context17.next) {
          case 0:
            http = _ref33.http, id = _ref33.id, namespaceType = _ref33.namespaceType, signal = _ref33.signal;
            return _context17.abrupt("return", http.fetch(EXCEPTION_LIST_URL, {
              method: 'DELETE',
              query: {
                id: id,
                namespace_type: namespaceType
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context17.stop();
        }
      }
    }, _callee17);
  }));

  return function deleteExceptionListById(_x17) {
    return _ref34.apply(this, arguments);
  };
}();

var deleteExceptionListByIdWithValidation = /*#__PURE__*/function () {
  var _ref36 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee18(_ref35) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee18$(_context18) {
      while (1) {
        switch (_context18.prev = _context18.next) {
          case 0:
            http = _ref35.http, id = _ref35.id, namespaceType = _ref35.namespaceType, signal = _ref35.signal;
            return _context18.abrupt("return", flow(function () {
              return tryCatch(function () {
                return deleteExceptionListById({
                  http: http,
                  id: id,
                  namespaceType: namespaceType,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context18.stop();
        }
      }
    }, _callee18);
  }));

  return function deleteExceptionListByIdWithValidation(_x18) {
    return _ref36.apply(this, arguments);
  };
}();

export { deleteExceptionListByIdWithValidation as deleteExceptionListById };
/**
 * Delete an ExceptionListItem by providing a ExceptionListItem ID
 *
 * @param http Kibana http service
 * @param id ExceptionListItem ID (not item_id)
 * @param namespaceType ExceptionList namespace_type
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */

var deleteExceptionListItemById = /*#__PURE__*/function () {
  var _ref38 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee19(_ref37) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee19$(_context19) {
      while (1) {
        switch (_context19.prev = _context19.next) {
          case 0:
            http = _ref37.http, id = _ref37.id, namespaceType = _ref37.namespaceType, signal = _ref37.signal;
            return _context19.abrupt("return", http.fetch(EXCEPTION_LIST_ITEM_URL, {
              method: 'DELETE',
              query: {
                id: id,
                namespace_type: namespaceType
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context19.stop();
        }
      }
    }, _callee19);
  }));

  return function deleteExceptionListItemById(_x19) {
    return _ref38.apply(this, arguments);
  };
}();

var deleteExceptionListItemByIdWithValidation = /*#__PURE__*/function () {
  var _ref40 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee20(_ref39) {
    var http, id, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee20$(_context20) {
      while (1) {
        switch (_context20.prev = _context20.next) {
          case 0:
            http = _ref39.http, id = _ref39.id, namespaceType = _ref39.namespaceType, signal = _ref39.signal;
            return _context20.abrupt("return", flow(function () {
              return tryCatch(function () {
                return deleteExceptionListItemById({
                  http: http,
                  id: id,
                  namespaceType: namespaceType,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(exceptionListItemSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context20.stop();
        }
      }
    }, _callee20);
  }));

  return function deleteExceptionListItemByIdWithValidation(_x20) {
    return _ref40.apply(this, arguments);
  };
}();

export { deleteExceptionListItemByIdWithValidation as deleteExceptionListItemById };
/**
 * Add new Endpoint ExceptionList
 *
 * @param http Kibana http service
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 *
 */

var addEndpointExceptionList = /*#__PURE__*/function () {
  var _ref42 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee21(_ref41) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee21$(_context21) {
      while (1) {
        switch (_context21.prev = _context21.next) {
          case 0:
            http = _ref41.http, signal = _ref41.signal;
            return _context21.abrupt("return", http.fetch(ENDPOINT_LIST_URL, {
              method: 'POST',
              signal: signal
            }));

          case 2:
          case "end":
            return _context21.stop();
        }
      }
    }, _callee21);
  }));

  return function addEndpointExceptionList(_x21) {
    return _ref42.apply(this, arguments);
  };
}();

var addEndpointExceptionListWithValidation = /*#__PURE__*/function () {
  var _ref44 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee22(_ref43) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee22$(_context22) {
      while (1) {
        switch (_context22.prev = _context22.next) {
          case 0:
            http = _ref43.http, signal = _ref43.signal;
            return _context22.abrupt("return", flow(function () {
              return tryCatch(function () {
                return addEndpointExceptionList({
                  http: http,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(createEndpointListSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context22.stop();
        }
      }
    }, _callee22);
  }));

  return function addEndpointExceptionListWithValidation(_x22) {
    return _ref44.apply(this, arguments);
  };
}();

export { addEndpointExceptionListWithValidation as addEndpointExceptionList };
/**
 * Fetch an ExceptionList by providing a ExceptionList ID
 *
 * @param http Kibana http service
 * @param id ExceptionList ID (not list_id)
 * @param listId ExceptionList LIST_ID (not id)
 * @param namespaceType ExceptionList namespace_type
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */

export var exportExceptionList = /*#__PURE__*/function () {
  var _ref46 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee23(_ref45) {
    var http, id, listId, namespaceType, signal;
    return _regeneratorRuntime.wrap(function _callee23$(_context23) {
      while (1) {
        switch (_context23.prev = _context23.next) {
          case 0:
            http = _ref45.http, id = _ref45.id, listId = _ref45.listId, namespaceType = _ref45.namespaceType, signal = _ref45.signal;
            return _context23.abrupt("return", http.fetch("".concat(EXCEPTION_LIST_URL, "/_export"), {
              method: 'POST',
              query: {
                id: id,
                list_id: listId,
                namespace_type: namespaceType
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context23.stop();
        }
      }
    }, _callee23);
  }));

  return function exportExceptionList(_x23) {
    return _ref46.apply(this, arguments);
  };
}();