/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { ENDPOINT_TRUSTED_APPS_LIST_ID } from '@kbn/securitysolution-list-constants';
export var getTrustedAppsFilter = function getTrustedAppsFilter(showTrustedApps, namespaceTypes) {
  if (showTrustedApps) {
    var filters = namespaceTypes.map(function (namespace) {
      return "".concat(namespace, ".attributes.list_id: ").concat(ENDPOINT_TRUSTED_APPS_LIST_ID, "*");
    });
    return "(".concat(filters.join(' OR '), ")");
  } else {
    var _filters = namespaceTypes.map(function (namespace) {
      return "not ".concat(namespace, ".attributes.list_id: ").concat(ENDPOINT_TRUSTED_APPS_LIST_ID, "*");
    });

    return "(".concat(_filters.join(' AND '), ")");
  }
};