"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMatchRoutes = useMatchRoutes;

var _react = require("react");

var _reactRouterDom = require("react-router-dom");

var _use_router = require("./use_router");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function useMatchRoutes(path) {
  const router = (0, _use_router.useRouter)();
  const location = (0, _reactRouterDom.useLocation)();
  const routeMatches = (0, _react.useMemo)(() => {
    return typeof path === 'undefined' ? router.matchRoutes(location) : router.matchRoutes(path, location);
  }, [path, router, location]);
  return routeMatches;
}