"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipSettings = void 0;
var settings_1 = require("../../specs/settings");
function getTooltipSettings(settings, isExternalTooltipVisible) {
    if (!isExternalTooltipVisible) {
        return settings.tooltip;
    }
    if ((0, settings_1.isTooltipType)(settings.tooltip)) {
        return __assign({ type: settings.tooltip }, settings.externalPointerEvents.tooltip);
    }
    return __assign(__assign({}, settings.tooltip), settings.externalPointerEvents.tooltip);
}
exports.getTooltipSettings = getTooltipSettings;
//# sourceMappingURL=get_tooltip_settings.js.map