import PropTypes from "prop-types";
import React from "react";
import { FacetValue } from "./types";
import { getFilterValueDisplay } from "./view-helpers";
import { appendClassName } from "./view-helpers";

function SingleLinksFacet(_ref) {
  var className = _ref.className,
      label = _ref.label,
      onRemove = _ref.onRemove,
      onSelect = _ref.onSelect,
      options = _ref.options;
  var value = options.filter(function (o) {
    return o.selected;
  }).map(function (o) {
    return o.value;
  })[0];
  return /*#__PURE__*/React.createElement("div", {
    className: appendClassName("sui-facet", className)
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
    className: "sui-facet__title"
  }, label), /*#__PURE__*/React.createElement("ul", {
    className: "sui-single-option-facet"
  }, value && /*#__PURE__*/React.createElement("li", {
    className: "sui-single-option-facet__selected"
  }, getFilterValueDisplay(value), " ", /*#__PURE__*/React.createElement("span", {
    className: "sui-single-option-facet__remove"
  }, "(", /*#__PURE__*/React.createElement("a", {
    onClick: function onClick(e) {
      e.preventDefault();
      onRemove(value);
    },
    href: "/"
  }, "Remove"), ")")), !value && options.map(function (option) {
    return /*#__PURE__*/React.createElement("li", {
      className: "sui-single-option-facet__item",
      key: getFilterValueDisplay(option.value)
    }, /*#__PURE__*/React.createElement("a", {
      className: "sui-single-option-facet__link",
      href: "/",
      onClick: function onClick(e) {
        e.preventDefault();
        onSelect(option.value);
      }
    }, getFilterValueDisplay(option.value)), " ", /*#__PURE__*/React.createElement("span", {
      className: "sui-facet__count"
    }, option.count));
  }))));
}

SingleLinksFacet.propTypes = {
  label: PropTypes.string.isRequired,
  onRemove: PropTypes.func.isRequired,
  onSelect: PropTypes.func.isRequired,
  options: PropTypes.arrayOf(FacetValue).isRequired,
  className: PropTypes.string
};
export default SingleLinksFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9TaW5nbGVMaW5rc0ZhY2V0LmpzIl0sIm5hbWVzIjpbIlByb3BUeXBlcyIsIlJlYWN0IiwiRmFjZXRWYWx1ZSIsImdldEZpbHRlclZhbHVlRGlzcGxheSIsImFwcGVuZENsYXNzTmFtZSIsIlNpbmdsZUxpbmtzRmFjZXQiLCJjbGFzc05hbWUiLCJsYWJlbCIsIm9uUmVtb3ZlIiwib25TZWxlY3QiLCJvcHRpb25zIiwidmFsdWUiLCJmaWx0ZXIiLCJvIiwic2VsZWN0ZWQiLCJtYXAiLCJlIiwicHJldmVudERlZmF1bHQiLCJvcHRpb24iLCJjb3VudCIsInByb3BUeXBlcyIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJmdW5jIiwiYXJyYXlPZiJdLCJtYXBwaW5ncyI6IkFBQUEsT0FBT0EsU0FBUCxNQUFzQixZQUF0QjtBQUNBLE9BQU9DLEtBQVAsTUFBa0IsT0FBbEI7QUFFQSxTQUFTQyxVQUFULFFBQTJCLFNBQTNCO0FBQ0EsU0FBU0MscUJBQVQsUUFBc0MsZ0JBQXRDO0FBQ0EsU0FBU0MsZUFBVCxRQUFnQyxnQkFBaEM7O0FBRUEsU0FBU0MsZ0JBQVQsT0FBNkU7QUFBQSxNQUFqREMsU0FBaUQsUUFBakRBLFNBQWlEO0FBQUEsTUFBdENDLEtBQXNDLFFBQXRDQSxLQUFzQztBQUFBLE1BQS9CQyxRQUErQixRQUEvQkEsUUFBK0I7QUFBQSxNQUFyQkMsUUFBcUIsUUFBckJBLFFBQXFCO0FBQUEsTUFBWEMsT0FBVyxRQUFYQSxPQUFXO0FBQzNFLE1BQU1DLEtBQUssR0FBR0QsT0FBTyxDQUFDRSxNQUFSLENBQWUsVUFBQUMsQ0FBQztBQUFBLFdBQUlBLENBQUMsQ0FBQ0MsUUFBTjtBQUFBLEdBQWhCLEVBQWdDQyxHQUFoQyxDQUFvQyxVQUFBRixDQUFDO0FBQUEsV0FBSUEsQ0FBQyxDQUFDRixLQUFOO0FBQUEsR0FBckMsRUFBa0QsQ0FBbEQsQ0FBZDtBQUNBLHNCQUNFO0FBQUssSUFBQSxTQUFTLEVBQUVQLGVBQWUsQ0FBQyxXQUFELEVBQWNFLFNBQWQ7QUFBL0Isa0JBQ0UsOENBQ0U7QUFBSyxJQUFBLFNBQVMsRUFBQztBQUFmLEtBQW1DQyxLQUFuQyxDQURGLGVBRUU7QUFBSSxJQUFBLFNBQVMsRUFBQztBQUFkLEtBQ0dJLEtBQUssaUJBQ0o7QUFBSSxJQUFBLFNBQVMsRUFBQztBQUFkLEtBQ0dSLHFCQUFxQixDQUFDUSxLQUFELENBRHhCLEVBQ2lDLEdBRGpDLGVBRUU7QUFBTSxJQUFBLFNBQVMsRUFBQztBQUFoQix1QkFFRTtBQUNFLElBQUEsT0FBTyxFQUFFLGlCQUFBSyxDQUFDLEVBQUk7QUFDWkEsTUFBQUEsQ0FBQyxDQUFDQyxjQUFGO0FBQ0FULE1BQUFBLFFBQVEsQ0FBQ0csS0FBRCxDQUFSO0FBQ0QsS0FKSDtBQUtFLElBQUEsSUFBSSxFQUFDO0FBTFAsY0FGRixNQUZGLENBRkosRUFtQkcsQ0FBQ0EsS0FBRCxJQUNDRCxPQUFPLENBQUNLLEdBQVIsQ0FBWSxVQUFBRyxNQUFNO0FBQUEsd0JBQ2hCO0FBQ0UsTUFBQSxTQUFTLEVBQUMsK0JBRFo7QUFFRSxNQUFBLEdBQUcsRUFBRWYscUJBQXFCLENBQUNlLE1BQU0sQ0FBQ1AsS0FBUjtBQUY1QixvQkFJRTtBQUNFLE1BQUEsU0FBUyxFQUFDLCtCQURaO0FBRUUsTUFBQSxJQUFJLEVBQUMsR0FGUDtBQUdFLE1BQUEsT0FBTyxFQUFFLGlCQUFBSyxDQUFDLEVBQUk7QUFDWkEsUUFBQUEsQ0FBQyxDQUFDQyxjQUFGO0FBQ0FSLFFBQUFBLFFBQVEsQ0FBQ1MsTUFBTSxDQUFDUCxLQUFSLENBQVI7QUFDRDtBQU5ILE9BUUdSLHFCQUFxQixDQUFDZSxNQUFNLENBQUNQLEtBQVIsQ0FSeEIsQ0FKRixFQWFPLEdBYlAsZUFjRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQW9DTyxNQUFNLENBQUNDLEtBQTNDLENBZEYsQ0FEZ0I7QUFBQSxHQUFsQixDQXBCSixDQUZGLENBREYsQ0FERjtBQThDRDs7QUFFRGQsZ0JBQWdCLENBQUNlLFNBQWpCLEdBQTZCO0FBQzNCYixFQUFBQSxLQUFLLEVBQUVQLFNBQVMsQ0FBQ3FCLE1BQVYsQ0FBaUJDLFVBREc7QUFFM0JkLEVBQUFBLFFBQVEsRUFBRVIsU0FBUyxDQUFDdUIsSUFBVixDQUFlRCxVQUZFO0FBRzNCYixFQUFBQSxRQUFRLEVBQUVULFNBQVMsQ0FBQ3VCLElBQVYsQ0FBZUQsVUFIRTtBQUkzQlosRUFBQUEsT0FBTyxFQUFFVixTQUFTLENBQUN3QixPQUFWLENBQWtCdEIsVUFBbEIsRUFBOEJvQixVQUpaO0FBSzNCaEIsRUFBQUEsU0FBUyxFQUFFTixTQUFTLENBQUNxQjtBQUxNLENBQTdCO0FBUUEsZUFBZWhCLGdCQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuXG5pbXBvcnQgeyBGYWNldFZhbHVlIH0gZnJvbSBcIi4vdHlwZXNcIjtcbmltcG9ydCB7IGdldEZpbHRlclZhbHVlRGlzcGxheSB9IGZyb20gXCIuL3ZpZXctaGVscGVyc1wiO1xuaW1wb3J0IHsgYXBwZW5kQ2xhc3NOYW1lIH0gZnJvbSBcIi4vdmlldy1oZWxwZXJzXCI7XG5cbmZ1bmN0aW9uIFNpbmdsZUxpbmtzRmFjZXQoeyBjbGFzc05hbWUsIGxhYmVsLCBvblJlbW92ZSwgb25TZWxlY3QsIG9wdGlvbnMgfSkge1xuICBjb25zdCB2YWx1ZSA9IG9wdGlvbnMuZmlsdGVyKG8gPT4gby5zZWxlY3RlZCkubWFwKG8gPT4gby52YWx1ZSlbMF07XG4gIHJldHVybiAoXG4gICAgPGRpdiBjbGFzc05hbWU9e2FwcGVuZENsYXNzTmFtZShcInN1aS1mYWNldFwiLCBjbGFzc05hbWUpfT5cbiAgICAgIDxkaXY+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPVwic3VpLWZhY2V0X190aXRsZVwiPntsYWJlbH08L2Rpdj5cbiAgICAgICAgPHVsIGNsYXNzTmFtZT1cInN1aS1zaW5nbGUtb3B0aW9uLWZhY2V0XCI+XG4gICAgICAgICAge3ZhbHVlICYmIChcbiAgICAgICAgICAgIDxsaSBjbGFzc05hbWU9XCJzdWktc2luZ2xlLW9wdGlvbi1mYWNldF9fc2VsZWN0ZWRcIj5cbiAgICAgICAgICAgICAge2dldEZpbHRlclZhbHVlRGlzcGxheSh2YWx1ZSl9e1wiIFwifVxuICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJzdWktc2luZ2xlLW9wdGlvbi1mYWNldF9fcmVtb3ZlXCI+XG4gICAgICAgICAgICAgICAgKFxuICAgICAgICAgICAgICAgIDxhXG4gICAgICAgICAgICAgICAgICBvbkNsaWNrPXtlID0+IHtcbiAgICAgICAgICAgICAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAgICAgICAgICAgICBvblJlbW92ZSh2YWx1ZSk7XG4gICAgICAgICAgICAgICAgICB9fVxuICAgICAgICAgICAgICAgICAgaHJlZj1cIi9cIlxuICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgIFJlbW92ZVxuICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgICAgICApXG4gICAgICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgKX1cbiAgICAgICAgICB7IXZhbHVlICYmXG4gICAgICAgICAgICBvcHRpb25zLm1hcChvcHRpb24gPT4gKFxuICAgICAgICAgICAgICA8bGlcbiAgICAgICAgICAgICAgICBjbGFzc05hbWU9XCJzdWktc2luZ2xlLW9wdGlvbi1mYWNldF9faXRlbVwiXG4gICAgICAgICAgICAgICAga2V5PXtnZXRGaWx0ZXJWYWx1ZURpc3BsYXkob3B0aW9uLnZhbHVlKX1cbiAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgIDxhXG4gICAgICAgICAgICAgICAgICBjbGFzc05hbWU9XCJzdWktc2luZ2xlLW9wdGlvbi1mYWNldF9fbGlua1wiXG4gICAgICAgICAgICAgICAgICBocmVmPVwiL1wiXG4gICAgICAgICAgICAgICAgICBvbkNsaWNrPXtlID0+IHtcbiAgICAgICAgICAgICAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAgICAgICAgICAgICBvblNlbGVjdChvcHRpb24udmFsdWUpO1xuICAgICAgICAgICAgICAgICAgfX1cbiAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICB7Z2V0RmlsdGVyVmFsdWVEaXNwbGF5KG9wdGlvbi52YWx1ZSl9XG4gICAgICAgICAgICAgICAgPC9hPntcIiBcIn1cbiAgICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJzdWktZmFjZXRfX2NvdW50XCI+e29wdGlvbi5jb3VudH08L3NwYW4+XG4gICAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgICApKX1cbiAgICAgICAgPC91bD5cbiAgICAgIDwvZGl2PlxuICAgIDwvZGl2PlxuICApO1xufVxuXG5TaW5nbGVMaW5rc0ZhY2V0LnByb3BUeXBlcyA9IHtcbiAgbGFiZWw6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgb25SZW1vdmU6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gIG9uU2VsZWN0OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICBvcHRpb25zOiBQcm9wVHlwZXMuYXJyYXlPZihGYWNldFZhbHVlKS5pc1JlcXVpcmVkLFxuICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmdcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFNpbmdsZUxpbmtzRmFjZXQ7XG4iXX0=