import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import { doFilterValuesMatch } from "../helpers";
/**
 * Filter results - Adds to current filter value
 *
 * Will trigger new search
 *
 * @param name String field name to filter on
 * @param value String field value to filter on
 * @param type String (Optional) type of filter to apply
 */

export default function addFilter(name, value) {
  var _console;

  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "all";
  // eslint-disable-next-line no-console
  if (this.debug) (_console = console).log.apply(_console, ["Search UI: Action", "addFilter"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  var existingFilter = filters.find(function (f) {
    return f.field === name && f.type === type;
  }) || {};
  var allOtherFilters = filters.filter(function (f) {
    return f.field !== name || f.type !== type;
  }) || [];
  var existingFilterValues = existingFilter.values || [];
  var newFilterValues = existingFilterValues.find(function (existing) {
    return doFilterValuesMatch(existing, value);
  }) ? existingFilterValues : existingFilterValues.concat(value);

  this._updateSearchResults({
    current: 1,
    filters: [].concat(_toConsumableArray(allOtherFilters), [{
      field: name,
      values: newFilterValues,
      type: type
    }])
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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