/**
 * Remove all filters
 *
 * Will trigger new search
 *
 * @param except Array[String] field name of any filters that should remain
 */
export default function clearFilters() {
  var _console;

  var except = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "clearFilters"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  var updatedFilters = filters.filter(function (filter) {
    var filterField = filter.field;
    return except.includes(filterField);
  });

  this._updateSearchResults({
    current: 1,
    filters: updatedFilters
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL2NsZWFyRmlsdGVycy5qcyJdLCJuYW1lcyI6WyJjbGVhckZpbHRlcnMiLCJleGNlcHQiLCJkZWJ1ZyIsImNvbnNvbGUiLCJsb2ciLCJhcmd1bWVudHMiLCJmaWx0ZXJzIiwic3RhdGUiLCJ1cGRhdGVkRmlsdGVycyIsImZpbHRlciIsImZpbHRlckZpZWxkIiwiZmllbGQiLCJpbmNsdWRlcyIsIl91cGRhdGVTZWFyY2hSZXN1bHRzIiwiY3VycmVudCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxlQUFlLFNBQVNBLFlBQVQsR0FBbUM7QUFBQTs7QUFBQSxNQUFiQyxNQUFhLHVFQUFKLEVBQUk7QUFDaEQsTUFBSSxLQUFLQyxLQUFULEVBQ0U7QUFDQSxnQkFBQUMsT0FBTyxFQUFDQyxHQUFSLGtCQUFZLG1CQUFaLEVBQWlDLGNBQWpDLG9DQUFvREMsU0FBcEQ7QUFIOEMsTUFLeENDLE9BTHdDLEdBSzVCLEtBQUtDLEtBTHVCLENBS3hDRCxPQUx3QztBQU9oRCxNQUFNRSxjQUFjLEdBQUdGLE9BQU8sQ0FBQ0csTUFBUixDQUFlLFVBQUFBLE1BQU0sRUFBSTtBQUM5QyxRQUFNQyxXQUFXLEdBQUdELE1BQU0sQ0FBQ0UsS0FBM0I7QUFDQSxXQUFPVixNQUFNLENBQUNXLFFBQVAsQ0FBZ0JGLFdBQWhCLENBQVA7QUFDRCxHQUhzQixDQUF2Qjs7QUFLQSxPQUFLRyxvQkFBTCxDQUEwQjtBQUN4QkMsSUFBQUEsT0FBTyxFQUFFLENBRGU7QUFFeEJSLElBQUFBLE9BQU8sRUFBRUU7QUFGZSxHQUExQjtBQUlEIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBSZW1vdmUgYWxsIGZpbHRlcnNcbiAqXG4gKiBXaWxsIHRyaWdnZXIgbmV3IHNlYXJjaFxuICpcbiAqIEBwYXJhbSBleGNlcHQgQXJyYXlbU3RyaW5nXSBmaWVsZCBuYW1lIG9mIGFueSBmaWx0ZXJzIHRoYXQgc2hvdWxkIHJlbWFpblxuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBjbGVhckZpbHRlcnMoZXhjZXB0ID0gW10pIHtcbiAgaWYgKHRoaXMuZGVidWcpXG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWNvbnNvbGVcbiAgICBjb25zb2xlLmxvZyhcIlNlYXJjaCBVSTogQWN0aW9uXCIsIFwiY2xlYXJGaWx0ZXJzXCIsIC4uLmFyZ3VtZW50cyk7XG5cbiAgY29uc3QgeyBmaWx0ZXJzIH0gPSB0aGlzLnN0YXRlO1xuXG4gIGNvbnN0IHVwZGF0ZWRGaWx0ZXJzID0gZmlsdGVycy5maWx0ZXIoZmlsdGVyID0+IHtcbiAgICBjb25zdCBmaWx0ZXJGaWVsZCA9IGZpbHRlci5maWVsZDtcbiAgICByZXR1cm4gZXhjZXB0LmluY2x1ZGVzKGZpbHRlckZpZWxkKTtcbiAgfSk7XG5cbiAgdGhpcy5fdXBkYXRlU2VhcmNoUmVzdWx0cyh7XG4gICAgY3VycmVudDogMSxcbiAgICBmaWx0ZXJzOiB1cGRhdGVkRmlsdGVyc1xuICB9KTtcbn1cbiJdfQ==