"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setResultsPerPage;

/**
 * Set the number of results to show
 *
 * Will trigger new search
 *
 * @param resultsPerPage Integer
 */
function setResultsPerPage(resultsPerPage) {
  var _console;

  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "setResultsPerPage"].concat(Array.prototype.slice.call(arguments)));

  this._updateSearchResults({
    current: 1,
    resultsPerPage: resultsPerPage
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL3NldFJlc3VsdHNQZXJQYWdlLmpzIl0sIm5hbWVzIjpbInNldFJlc3VsdHNQZXJQYWdlIiwicmVzdWx0c1BlclBhZ2UiLCJkZWJ1ZyIsImNvbnNvbGUiLCJsb2ciLCJhcmd1bWVudHMiLCJfdXBkYXRlU2VhcmNoUmVzdWx0cyIsImN1cnJlbnQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNlLFNBQVNBLGlCQUFULENBQTJCQyxjQUEzQixFQUEyQztBQUFBOztBQUN4RCxNQUFJLEtBQUtDLEtBQVQsRUFDRTtBQUNBLGdCQUFBQyxPQUFPLEVBQUNDLEdBQVIsa0JBQVksbUJBQVosRUFBaUMsbUJBQWpDLG9DQUF5REMsU0FBekQ7O0FBRUYsT0FBS0Msb0JBQUwsQ0FBMEI7QUFDeEJDLElBQUFBLE9BQU8sRUFBRSxDQURlO0FBRXhCTixJQUFBQSxjQUFjLEVBQWRBO0FBRndCLEdBQTFCO0FBSUQiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFNldCB0aGUgbnVtYmVyIG9mIHJlc3VsdHMgdG8gc2hvd1xuICpcbiAqIFdpbGwgdHJpZ2dlciBuZXcgc2VhcmNoXG4gKlxuICogQHBhcmFtIHJlc3VsdHNQZXJQYWdlIEludGVnZXJcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gc2V0UmVzdWx0c1BlclBhZ2UocmVzdWx0c1BlclBhZ2UpIHtcbiAgaWYgKHRoaXMuZGVidWcpXG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWNvbnNvbGVcbiAgICBjb25zb2xlLmxvZyhcIlNlYXJjaCBVSTogQWN0aW9uXCIsIFwic2V0UmVzdWx0c1BlclBhZ2VcIiwgLi4uYXJndW1lbnRzKTtcblxuICB0aGlzLl91cGRhdGVTZWFyY2hSZXN1bHRzKHtcbiAgICBjdXJyZW50OiAxLFxuICAgIHJlc3VsdHNQZXJQYWdlXG4gIH0pO1xufVxuIl19