"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NeverType = void 0;

var _internals = require("../internals");

var _type = require("./type");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class NeverType extends _type.Type {
  constructor() {
    super(_internals.internals.any().forbidden());
  }

  handleError(type) {
    switch (type) {
      case 'any.unknown':
        return "a value wasn't expected to be present";
    }
  }

}

exports.NeverType = NeverType;