"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnFieldType = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _types = require("./types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class KbnFieldType {
  constructor(options = {}) {
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "sortable", void 0);
    (0, _defineProperty2.default)(this, "filterable", void 0);
    (0, _defineProperty2.default)(this, "esTypes", void 0);
    this.name = options.name || _types.KBN_FIELD_TYPES.UNKNOWN;
    this.sortable = options.sortable || false;
    this.filterable = options.filterable || false;
    this.esTypes = Object.freeze((options.esTypes || []).slice());
  }

}

exports.KbnFieldType = KbnFieldType;