/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the positive integer greater than zero is:
 *   - Natural Number (positive integer and not a float),
 *   - 1 or greater
 */
export var PositiveIntegerGreaterThanZero = new t.Type('PositiveIntegerGreaterThanZero', t.number.is, function (input, context) {
  return typeof input === 'number' && Number.isSafeInteger(input) && input >= 1 ? t.success(input) : t.failure(input, context);
}, t.identity);