"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderRectAnnotations = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var rect_1 = require("../primitives/rect");
var panel_transform_1 = require("../utils/panel_transform");
function renderRectAnnotations(ctx, annotations, rectStyle, rotation, renderingArea) {
    var fill = {
        color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)(rectStyle.fill), function (opacity) { return opacity * rectStyle.opacity; }),
    };
    var stroke = {
        color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)(rectStyle.stroke), function (opacity) { return opacity * rectStyle.opacity; }),
        width: rectStyle.strokeWidth,
    };
    annotations.forEach(function (_a) {
        var rect = _a.rect, panel = _a.panel;
        return (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, function () { return (0, rect_1.renderRect)(ctx, rect, fill, stroke); });
    });
}
exports.renderRectAnnotations = renderRectAnnotations;
//# sourceMappingURL=rect.js.map