import { announceToScreenReader } from "../A11yNotifications";
/**
 * Announces a specific message in `a11yNotificationMessages`
 * to Search UI's screen reader live region.
 *
 * @param {string} messageFunc - key of a message function in `a11yNotificationMessages`
 * @param {object} [messageArgs] - arguments to pass to the message function, if any
 */

export default function a11yNotify(messageFunc, messageArgs) {
  if (!this.hasA11yNotifications) return;
  var getMessage = this.a11yNotificationMessages[messageFunc];

  if (!getMessage) {
    var errorMessage = "Could not find corresponding message function in a11yNotificationMessages: \"".concat(messageFunc, "\"");
    console.warn("Action", "a11yNotify", errorMessage);
    return;
  }

  var message = getMessage(messageArgs);
  announceToScreenReader(message);

  if (this.debug) {
    // eslint-disable-next-line no-console
    console.log("Search UI: Action", "a11yNotify", {
      messageFunc: messageFunc,
      messageArgs: messageArgs,
      message: message
    });
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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