"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

/*
  This deals with sequencing of our async requests. When a lot of requests are firing very close to one another
  and are running in parallel, what happens if they return out of order? It creates a race condition.

  For example, if I type the term "react" in the search box, two queries may be initiated, in parallel.

  1. query for "reac"
  2. query for "react"

  If the query for "react" actually returns **before** the query for "reac",
  we could end up looking at the results for "reac", despite having typed "react" in the search box.

  To deal with this, we keep track of a sequence.
  */
var RequestSequencer = /*#__PURE__*/function () {
  function RequestSequencer() {
    (0, _classCallCheck2.default)(this, RequestSequencer);
    (0, _defineProperty2.default)(this, "requestSequence", 0);
    (0, _defineProperty2.default)(this, "lastCompleted", 0);
  }

  (0, _createClass2.default)(RequestSequencer, [{
    key: "next",
    value: function next() {
      return ++this.requestSequence;
    }
  }, {
    key: "isOldRequest",
    value: function isOldRequest(request) {
      return request < this.lastCompleted;
    }
  }, {
    key: "completed",
    value: function completed(request) {
      this.lastCompleted = request;
    }
  }]);
  return RequestSequencer;
}();

exports.default = RequestSequencer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9SZXF1ZXN0U2VxdWVuY2VyLmpzIl0sIm5hbWVzIjpbIlJlcXVlc3RTZXF1ZW5jZXIiLCJyZXF1ZXN0U2VxdWVuY2UiLCJyZXF1ZXN0IiwibGFzdENvbXBsZXRlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtJQUNxQkEsZ0I7OzsyREFDRCxDO3lEQUNGLEM7Ozs7O1dBRWhCLGdCQUFPO0FBQ0wsYUFBTyxFQUFFLEtBQUtDLGVBQWQ7QUFDRDs7O1dBRUQsc0JBQWFDLE9BQWIsRUFBc0I7QUFDcEIsYUFBT0EsT0FBTyxHQUFHLEtBQUtDLGFBQXRCO0FBQ0Q7OztXQUVELG1CQUFVRCxPQUFWLEVBQW1CO0FBQ2pCLFdBQUtDLGFBQUwsR0FBcUJELE9BQXJCO0FBQ0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICBUaGlzIGRlYWxzIHdpdGggc2VxdWVuY2luZyBvZiBvdXIgYXN5bmMgcmVxdWVzdHMuIFdoZW4gYSBsb3Qgb2YgcmVxdWVzdHMgYXJlIGZpcmluZyB2ZXJ5IGNsb3NlIHRvIG9uZSBhbm90aGVyXG4gIGFuZCBhcmUgcnVubmluZyBpbiBwYXJhbGxlbCwgd2hhdCBoYXBwZW5zIGlmIHRoZXkgcmV0dXJuIG91dCBvZiBvcmRlcj8gSXQgY3JlYXRlcyBhIHJhY2UgY29uZGl0aW9uLlxuXG4gIEZvciBleGFtcGxlLCBpZiBJIHR5cGUgdGhlIHRlcm0gXCJyZWFjdFwiIGluIHRoZSBzZWFyY2ggYm94LCB0d28gcXVlcmllcyBtYXkgYmUgaW5pdGlhdGVkLCBpbiBwYXJhbGxlbC5cblxuICAxLiBxdWVyeSBmb3IgXCJyZWFjXCJcbiAgMi4gcXVlcnkgZm9yIFwicmVhY3RcIlxuXG4gIElmIHRoZSBxdWVyeSBmb3IgXCJyZWFjdFwiIGFjdHVhbGx5IHJldHVybnMgKipiZWZvcmUqKiB0aGUgcXVlcnkgZm9yIFwicmVhY1wiLFxuICB3ZSBjb3VsZCBlbmQgdXAgbG9va2luZyBhdCB0aGUgcmVzdWx0cyBmb3IgXCJyZWFjXCIsIGRlc3BpdGUgaGF2aW5nIHR5cGVkIFwicmVhY3RcIiBpbiB0aGUgc2VhcmNoIGJveC5cblxuICBUbyBkZWFsIHdpdGggdGhpcywgd2Uga2VlcCB0cmFjayBvZiBhIHNlcXVlbmNlLlxuICAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUmVxdWVzdFNlcXVlbmNlciB7XG4gIHJlcXVlc3RTZXF1ZW5jZSA9IDA7XG4gIGxhc3RDb21wbGV0ZWQgPSAwO1xuXG4gIG5leHQoKSB7XG4gICAgcmV0dXJuICsrdGhpcy5yZXF1ZXN0U2VxdWVuY2U7XG4gIH1cblxuICBpc09sZFJlcXVlc3QocmVxdWVzdCkge1xuICAgIHJldHVybiByZXF1ZXN0IDwgdGhpcy5sYXN0Q29tcGxldGVkO1xuICB9XG5cbiAgY29tcGxldGVkKHJlcXVlc3QpIHtcbiAgICB0aGlzLmxhc3RDb21wbGV0ZWQgPSByZXF1ZXN0O1xuICB9XG59XG4iXX0=