import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _toArray from "@babel/runtime/helpers/toArray";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import _ from 'lodash';
import { nodeTypes } from '../node_types';
import * as ast from '../ast';
export function buildNodeParams(fieldName, params) {
  params = _.pick(params, 'topLeft', 'bottomRight');
  var fieldNameArg = nodeTypes.literal.buildNode(fieldName);

  var args = _.map(params, function (value, key) {
    var latLon = "".concat(value.lat, ", ").concat(value.lon);
    return nodeTypes.namedArg.buildNode(key, latLon);
  });

  return {
    arguments: [fieldNameArg].concat(_toConsumableArray(args))
  };
}
export function toElasticsearchQuery(node, indexPattern) {
  var _indexPattern$fields, _geo_bounding_box;

  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  var _node$arguments = _toArray(node.arguments),
      fieldNameArg = _node$arguments[0],
      args = _node$arguments.slice(1);

  var fullFieldNameArg = _objectSpread(_objectSpread({}, fieldNameArg), {}, {
    value: context !== null && context !== void 0 && context.nested ? "".concat(context.nested.path, ".").concat(fieldNameArg.value) : fieldNameArg.value
  });

  var fieldName = nodeTypes.literal.toElasticsearchQuery(fullFieldNameArg);
  var fieldList = (_indexPattern$fields = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fields) !== null && _indexPattern$fields !== void 0 ? _indexPattern$fields : [];
  var field = fieldList.find(function (fld) {
    return fld.name === fieldName;
  });
  var queryParams = args.reduce(function (acc, arg) {
    var snakeArgName = _.snakeCase(arg.name);

    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, snakeArgName, ast.toElasticsearchQuery(arg)));
  }, {});

  if (field !== null && field !== void 0 && field.scripted) {
    throw new Error("Geo bounding box query does not support scripted fields");
  }

  return {
    geo_bounding_box: (_geo_bounding_box = {}, _defineProperty(_geo_bounding_box, fieldName, queryParams), _defineProperty(_geo_bounding_box, "ignore_unmapped", true), _geo_bounding_box)
  };
}