/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
/**
 * Converts string value to a Typescript enum
 *  - "foo" -> MyEnum.foo
 *
 * @param name Enum name
 * @param originalEnum Typescript enum
 * @returns Codec
 */

export function enumeration(name, originalEnum) {
  var isEnumValue = function isEnumValue(input) {
    return Object.values(originalEnum).includes(input);
  };

  return new t.Type(name, isEnumValue, function (input, context) {
    return isEnumValue(input) ? t.success(input) : t.failure(input, context);
  }, t.identity);
}