"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterStream = createFilterStream;

var _stream = require("stream");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function createFilterStream(fn) {
  return new _stream.Transform({
    objectMode: true,

    async transform(obj, enc, done) {
      const canPushDownStream = fn(obj);

      if (canPushDownStream) {
        this.push(obj);
      }

      done();
    }

  });
}