"use strict";

exports.__esModule = true;
exports.bootstrap = bootstrap;
exports.bootstrapPerf = bootstrapPerf;

var _utils = require("./common/utils");

var _patching = require("./common/patching");

var _state = require("./state");

var enabled = false;

function bootstrap() {
  if ((0, _utils.isPlatformSupported)()) {
    (0, _patching.patchAll)();
    bootstrapPerf();
    _state.state.bootstrapTime = (0, _utils.now)();
    enabled = true;
  } else if (_utils.isBrowser) {
    console.log('[Elastic APM] platform is not supported!');
  }

  return enabled;
}

function bootstrapPerf() {
  if (document.visibilityState === 'hidden') {
    _state.state.lastHiddenStart = 0;
  }

  window.addEventListener('visibilitychange', function () {
    if (document.visibilityState === 'hidden') {
      _state.state.lastHiddenStart = performance.now();
    }
  }, {
    capture: true
  });
}