"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LIGHT_THEME = void 0;
var colors_1 = require("../../common/colors");
var colors_2 = require("./colors");
var theme_common_1 = require("./theme_common");
exports.LIGHT_THEME = {
    chartPaddings: theme_common_1.DEFAULT_CHART_PADDING,
    chartMargins: theme_common_1.DEFAULT_CHART_MARGINS,
    lineSeriesStyle: {
        line: {
            visible: true,
            strokeWidth: 1,
            opacity: 1,
        },
        point: {
            visible: true,
            strokeWidth: 1,
            fill: colors_1.Colors.White.keyword,
            radius: 2,
            opacity: 1,
        },
    },
    bubbleSeriesStyle: {
        point: {
            visible: true,
            strokeWidth: 1,
            fill: colors_1.Colors.White.keyword,
            radius: 2,
            opacity: 1,
        },
    },
    areaSeriesStyle: {
        area: {
            visible: true,
            opacity: 0.3,
        },
        line: {
            visible: true,
            strokeWidth: 1,
            opacity: 1,
        },
        point: {
            visible: false,
            strokeWidth: 1,
            fill: colors_1.Colors.White.keyword,
            radius: 2,
            opacity: 1,
        },
    },
    barSeriesStyle: {
        rect: {
            opacity: 1,
        },
        rectBorder: {
            visible: false,
            strokeWidth: 1,
        },
        displayValue: {
            fontSize: 8,
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            padding: 0,
            fill: '#777',
            offsetX: 0,
            offsetY: 0,
        },
    },
    arcSeriesStyle: {
        arc: {
            visible: true,
            stroke: colors_1.Colors.Black.keyword,
            strokeWidth: 1,
            opacity: 1,
        },
    },
    sharedStyle: theme_common_1.DEFAULT_GEOMETRY_STYLES,
    scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05,
    },
    axes: {
        axisTitle: {
            visible: true,
            fontSize: 12,
            fontFamily: 'sans-serif',
            padding: {
                inner: 8,
                outer: 0,
            },
            fill: '#333',
        },
        axisPanelTitle: {
            visible: true,
            fontSize: 10,
            fontFamily: 'sans-serif',
            padding: {
                inner: 8,
                outer: 0,
            },
            fill: '#333',
        },
        axisLine: {
            visible: true,
            stroke: '#eaeaea',
            strokeWidth: 1,
        },
        tickLabel: {
            visible: true,
            fontSize: 10,
            fontFamily: 'sans-serif',
            fontStyle: 'normal',
            fill: '#777',
            padding: 0,
            rotation: 0,
            offset: {
                x: 0,
                y: 0,
                reference: 'local',
            },
            alignment: {
                vertical: 'near',
                horizontal: 'near',
            },
        },
        tickLine: {
            visible: true,
            stroke: '#eaeaea',
            strokeWidth: 1,
            size: 10,
            padding: 10,
        },
        gridLine: {
            horizontal: {
                visible: false,
                stroke: '#D3DAE6',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
            vertical: {
                visible: false,
                stroke: '#D3DAE6',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
        },
    },
    colors: {
        vizColors: colors_2.palettes.echPaletteColorBlind.colors,
        defaultVizColor: theme_common_1.DEFAULT_MISSING_COLOR,
    },
    legend: {
        verticalWidth: 200,
        horizontalHeight: 64,
        spacingBuffer: 10,
        margin: 0,
        labelOptions: {
            maxLines: 1,
        },
    },
    crosshair: {
        band: {
            fill: '#F5F5F5',
            visible: true,
        },
        line: {
            stroke: '#98A2B3',
            strokeWidth: 1,
            visible: true,
        },
        crossLine: {
            stroke: '#98A2B3',
            strokeWidth: 1,
            dash: [5, 5],
            visible: true,
        },
    },
    background: {
        color: colors_1.Colors.Transparent.keyword,
    },
    goal: {
        minFontSize: 8,
        maxFontSize: 64,
        tickLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: colors_1.Colors.Black.keyword,
        },
        majorLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: colors_1.Colors.Black.keyword,
        },
        minorLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: colors_1.Colors.Black.keyword,
        },
        majorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: colors_1.Colors.Black.keyword,
        },
        minorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: colors_1.Colors.Black.keyword,
        },
        targetLine: {
            stroke: colors_1.Colors.Black.keyword,
        },
        tickLine: {
            stroke: 'darkgrey',
        },
        progressLine: {
            stroke: colors_1.Colors.Black.keyword,
        },
    },
};
//# sourceMappingURL=light_theme.js.map