var VALID_PROTOCOLS = ["http:", "https:"];
/**
 *
 * @param {URL} URLParser URL interface provided by browser https://developer.mozilla.org/en-US/docs/Web/API/URL
 * @param {String} currentLocation String representation of the browser's current location
 */

export default function getUrlSanitizer(URLParser, currentLocation) {
  // This function is curried so that dependencies can be injected and don't need to be mocked in tests.
  return function (url) {
    var parsedUrl = {};

    try {
      // Attempts to parse a URL as relative
      parsedUrl = new URLParser(url, currentLocation); // eslint-disable-next-line no-empty
    } catch (e) {}

    return VALID_PROTOCOLS.includes(parsedUrl.protocol) ? url : "";
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy92aWV3LWhlbHBlcnMvZ2V0VXJsU2FuaXRpemVyLmpzIl0sIm5hbWVzIjpbIlZBTElEX1BST1RPQ09MUyIsImdldFVybFNhbml0aXplciIsIlVSTFBhcnNlciIsImN1cnJlbnRMb2NhdGlvbiIsInVybCIsInBhcnNlZFVybCIsImUiLCJpbmNsdWRlcyIsInByb3RvY29sIl0sIm1hcHBpbmdzIjoiQUFBQSxJQUFNQSxlQUFlLEdBQUcsQ0FBQyxPQUFELEVBQVUsUUFBVixDQUF4QjtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0EsZUFBZSxTQUFTQyxlQUFULENBQXlCQyxTQUF6QixFQUFvQ0MsZUFBcEMsRUFBcUQ7QUFDbEU7QUFDQSxTQUFPLFVBQUFDLEdBQUcsRUFBSTtBQUNaLFFBQUlDLFNBQVMsR0FBRyxFQUFoQjs7QUFFQSxRQUFJO0FBQ0Y7QUFDQUEsTUFBQUEsU0FBUyxHQUFHLElBQUlILFNBQUosQ0FBY0UsR0FBZCxFQUFtQkQsZUFBbkIsQ0FBWixDQUZFLENBR0Y7QUFDRCxLQUpELENBSUUsT0FBT0csQ0FBUCxFQUFVLENBQUU7O0FBRWQsV0FBT04sZUFBZSxDQUFDTyxRQUFoQixDQUF5QkYsU0FBUyxDQUFDRyxRQUFuQyxJQUErQ0osR0FBL0MsR0FBcUQsRUFBNUQ7QUFDRCxHQVZEO0FBV0QiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBWQUxJRF9QUk9UT0NPTFMgPSBbXCJodHRwOlwiLCBcImh0dHBzOlwiXTtcblxuLyoqXG4gKlxuICogQHBhcmFtIHtVUkx9IFVSTFBhcnNlciBVUkwgaW50ZXJmYWNlIHByb3ZpZGVkIGJ5IGJyb3dzZXIgaHR0cHM6Ly9kZXZlbG9wZXIubW96aWxsYS5vcmcvZW4tVVMvZG9jcy9XZWIvQVBJL1VSTFxuICogQHBhcmFtIHtTdHJpbmd9IGN1cnJlbnRMb2NhdGlvbiBTdHJpbmcgcmVwcmVzZW50YXRpb24gb2YgdGhlIGJyb3dzZXIncyBjdXJyZW50IGxvY2F0aW9uXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGdldFVybFNhbml0aXplcihVUkxQYXJzZXIsIGN1cnJlbnRMb2NhdGlvbikge1xuICAvLyBUaGlzIGZ1bmN0aW9uIGlzIGN1cnJpZWQgc28gdGhhdCBkZXBlbmRlbmNpZXMgY2FuIGJlIGluamVjdGVkIGFuZCBkb24ndCBuZWVkIHRvIGJlIG1vY2tlZCBpbiB0ZXN0cy5cbiAgcmV0dXJuIHVybCA9PiB7XG4gICAgbGV0IHBhcnNlZFVybCA9IHt9O1xuXG4gICAgdHJ5IHtcbiAgICAgIC8vIEF0dGVtcHRzIHRvIHBhcnNlIGEgVVJMIGFzIHJlbGF0aXZlXG4gICAgICBwYXJzZWRVcmwgPSBuZXcgVVJMUGFyc2VyKHVybCwgY3VycmVudExvY2F0aW9uKTtcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1lbXB0eVxuICAgIH0gY2F0Y2ggKGUpIHt9XG5cbiAgICByZXR1cm4gVkFMSURfUFJPVE9DT0xTLmluY2x1ZGVzKHBhcnNlZFVybC5wcm90b2NvbCkgPyB1cmwgOiBcIlwiO1xuICB9O1xufVxuIl19