/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { NonEmptyString } from '@kbn/securitysolution-io-ts-types';
import { created_at } from '../created_at';
import { created_by } from '../created_by';
import { id } from '../id';
import { updated_at } from '../updated_at';
import { updated_by } from '../updated_by';
export var comment = t.intersection([t.exact(t.type({
  comment: NonEmptyString,
  created_at: created_at,
  created_by: created_by,
  id: id
})), t.exact(t.partial({
  updated_at: updated_at,
  updated_by: updated_by
}))]);
export var commentsArray = t.array(comment);
export var commentsArrayOrUndefined = t.union([commentsArray, t.undefined]);