/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { comment } from '../comment';
/**
 * Types the DefaultCommentsArray as:
 *   - If null or undefined, then a default array of type entry will be set
 */

export var DefaultCommentsArray = new t.Type('DefaultCommentsArray', t.array(comment).is, function (input) {
  return input == null ? t.success([]) : t.array(comment).decode(input);
}, t.identity);