import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
export var getIdsAndNamespaces = function getIdsAndNamespaces(_ref) {
  var lists = _ref.lists,
      showDetection = _ref.showDetection,
      showEndpoint = _ref.showEndpoint;
  return lists.filter(function (list) {
    if (showDetection) {
      return list.type === 'detection';
    } else if (showEndpoint) {
      return list.type === 'endpoint';
    } else {
      return true;
    }
  }).reduce(function (acc, _ref2) {
    var listId = _ref2.listId,
        namespaceType = _ref2.namespaceType;
    return {
      ids: [].concat(_toConsumableArray(acc.ids), [listId]),
      namespaces: [].concat(_toConsumableArray(acc.namespaces), [namespaceType])
    };
  }, {
    ids: [],
    namespaces: []
  });
};