/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { createContext, useContext } from 'react';
import { OutletContextProvider } from './outlet';
import { jsx as ___EmotionJSX } from "@emotion/react";
var CurrentRouteContext = /*#__PURE__*/createContext(undefined);
export var CurrentRouteContextProvider = function CurrentRouteContextProvider(_ref) {
  var match = _ref.match,
      element = _ref.element,
      children = _ref.children;
  return ___EmotionJSX(CurrentRouteContext.Provider, {
    value: {
      match: match,
      element: element
    }
  }, ___EmotionJSX(OutletContextProvider, {
    element: element
  }, children));
};
export var useCurrentRoute = function useCurrentRoute() {
  var currentRoute = useContext(CurrentRouteContext);

  if (!currentRoute) {
    throw new Error('No match was found in context');
  }

  return currentRoute;
};