"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeResolveWorkpadRoute = initializeResolveWorkpadRoute;

var _configSchema = require("@kbn/config-schema");

var _constants = require("../../../common/lib/constants");

var _catch_error_handler = require("../catch_error_handler");

var _shim_workpad = require("./shim_workpad");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function initializeResolveWorkpadRoute(deps) {
  const {
    router
  } = deps;
  router.get({
    path: `${_constants.API_ROUTE_WORKPAD}/resolve/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, (0, _catch_error_handler.catchErrorHandler)(async (context, request, response) => {
    const resolved = await context.canvas.workpad.resolve(request.params.id);
    const {
      saved_object: workpad
    } = resolved;
    (0, _shim_workpad.shimWorkpad)(workpad);
    return response.ok({
      body: {
        workpad: {
          id: workpad.id,
          ...workpad.attributes
        },
        outcome: resolved.outcome,
        aliasId: resolved.alias_target_id
      }
    });
  }));
}