"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTick = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var common_1 = require("../../../../../utils/common");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
var line_1 = require("../primitives/line");
function renderTick(ctx, _a, _b) {
    var tickPosition = _a.position;
    var axisPosition = _b.axisSpec.position, _c = _b.size, width = _c.width, height = _c.height, tickLine = _b.axisStyle.tickLine;
    var xy = (0, axis_type_utils_1.isHorizontalAxis)(axisPosition)
        ? __assign({ x1: tickPosition, x2: tickPosition }, (axisPosition === common_1.Position.Top ? { y1: height - tickLine.size, y2: height } : { y1: 0, y2: tickLine.size })) : __assign({ y1: tickPosition, y2: tickPosition }, (axisPosition === common_1.Position.Left ? { x1: width, x2: width - tickLine.size } : { x1: 0, x2: tickLine.size }));
    (0, line_1.renderMultiLine)(ctx, [xy], { color: (0, color_library_wrappers_1.colorToRgba)(tickLine.stroke), width: tickLine.strokeWidth });
}
exports.renderTick = renderTick;
//# sourceMappingURL=tick.js.map