import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import deepEqual from "deep-equal";
/**
 * Given a list of applied Filters, find FilterValues based on
 * "fieldName" and "filterType".
 *
 * @param {*} filters
 * @param {*} name
 * @param {*} filterType
 */

export function findFilterValues(filters, name, filterType) {
  var filter = filters.find(function (f) {
    return f.field === name && f.type === filterType;
  });
  if (!filter) return [];
  return filter.values;
}
/**
 * Given a list of applied Filters, remove a single FilterValue based on
 * "fieldName" and "filterType".
 *
 * @param {Filter[]} filters
 * @param {String} fieldName
 * @param {FilterValue} value
 * @param {FilterType} filterType
 */

export function removeSingleFilterValue(filters, fieldName, value, filterType) {
  return filters.reduce(function (acc, filter) {
    var field = filter.field,
        values = filter.values,
        type = filter.type,
        rest = _objectWithoutProperties(filter, ["field", "values", "type"]);

    if (field === fieldName && (!filterType || type === filterType)) {
      var updatedFilterValues = values.filter(function (filterValue) {
        return !doFilterValuesMatch(filterValue, value);
      });

      if (updatedFilterValues.length > 0) {
        return acc.concat(_objectSpread({
          field: field,
          values: updatedFilterValues,
          type: type
        }, rest));
      } else {
        return acc;
      }
    }

    return acc.concat(filter);
  }, []);
}
/**
 * Given a Facet and a list of applied Filters, mark the Facet Values
 * for that Facet as "selected" based on "fieldName" and "filterType".
 *
 * @param {Facet} facet
 * @param {String} fieldName
 * @param {Filter[]} filters
 * @param {FilterType} filterType
 */

export function markSelectedFacetValuesFromFilters(facet, filters, fieldName, filterType) {
  var facetValues = facet.data;
  var filterValuesForField = findFilterValues(filters, fieldName, filterType) || [];
  return _objectSpread(_objectSpread({}, facet), {}, {
    data: facetValues.map(function (facetValue) {
      return _objectSpread(_objectSpread({}, facetValue), {}, {
        selected: filterValuesForField.some(function (filterValue) {
          return doFilterValuesMatch(filterValue, facetValue.value);
        })
      });
    })
  });
}
/**
 * Useful for determining when filter values match. This could be used
 * when matching applied filters back to facet options, or for determining
 * whether or not a filter already exists in a list of applied filters.
 *
 * @param {FilterValue} filterValue1
 * @param {FilterValue} filterValue2
 */

export function doFilterValuesMatch(filterValue1, filterValue2) {
  if (filterValue1 && filterValue1.name && filterValue2 && filterValue2.name && filterValue1.name === filterValue2.name) // If two filters have matching names, then they are the same filter, there
    // is no need to do a more expensive deep equal comparison.
    //
    // This is also important because certain filters and facets will have
    // differing values than their corresponding facet options. For instance,
    // consider a time-based facet like "Last 10 Minutes". The value of the
    // filter will be different depending on when it was selected, but the name
    // will always match.
    return true; // We use 'strict = true' to do a '===' of leaves, rather than '=='

  return deepEqual(filterValue1, filterValue2, {
    strict: true
  });
} // Mix unique filter type from one array into the other

export function mergeFilters(filters1, filters2) {
  if (!filters2) return filters1;
  return filters2.reduce(function (acc, next) {
    if (acc.find(function (f) {
      return f.type === next.type && f.field === next.field;
    })) {
      return acc;
    }

    return [].concat(_toConsumableArray(acc), [next]);
  }, filters1);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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