/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { useMemo } from 'react';
import { useLocation } from 'react-router-dom';
import { useRouter } from './use_router';
export function useMatchRoutes(path) {
  var router = useRouter();
  var location = useLocation();
  var routeMatches = useMemo(function () {
    return typeof path === 'undefined' ? router.matchRoutes(location) : router.matchRoutes(path, location);
  }, [path, router, location]);
  return routeMatches;
}