"use strict";

exports.__esModule = true;
exports.createTracer = createTracer;

var _tracer = _interopRequireDefault(require("./tracer"));

exports.Tracer = _tracer.default;

var _span = _interopRequireDefault(require("./span"));

exports.Span = _span.default;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createTracer(serviceFactory) {
  var performanceMonitoring = serviceFactory.getService('PerformanceMonitoring');
  var transactionService = serviceFactory.getService('TransactionService');
  var errorLogging = serviceFactory.getService('ErrorLogging');
  var loggingService = serviceFactory.getService('LoggingService');
  return new _tracer.default(performanceMonitoring, transactionService, loggingService, errorLogging);
}