"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.snapDateToESInterval = exports.ES_FIXED_INTERVAL_UNIT_TO_BASE = void 0;
var chrono_1 = require("./chrono");
exports.ES_FIXED_INTERVAL_UNIT_TO_BASE = {
    ms: 1,
    s: 1000,
    m: 1000 * 60,
    h: 1000 * 60 * 60,
    d: 1000 * 60 * 60 * 24,
};
var esCalendarIntervalToChronoInterval = {
    minute: 'minute',
    m: 'minute',
    hour: 'hour',
    h: 'hour',
    day: 'day',
    d: 'day',
    week: 'week',
    w: 'week',
    month: 'month',
    M: 'month',
    quarter: 'quarter',
    q: 'quarter',
    year: 'year',
    y: 'year',
};
function snapDateToESInterval(date, interval, snapTo, timeZone) {
    return isCalendarInterval(interval)
        ? esCalendarIntervalSnap(date, interval, snapTo, timeZone)
        : esFixedIntervalSnap(date, interval, snapTo, timeZone);
}
exports.snapDateToESInterval = snapDateToESInterval;
function isCalendarInterval(interval) {
    return interval.type === 'calendar';
}
function esCalendarIntervalSnap(date, interval, snapTo, timeZone) {
    return snapTo === 'start'
        ? (0, chrono_1.startOf)(date, timeZone, esCalendarIntervalToChronoInterval[interval.unit])
        : (0, chrono_1.endOf)(date, timeZone, esCalendarIntervalToChronoInterval[interval.unit]);
}
function esFixedIntervalSnap(date, interval, snapTo, timeZone) {
    var unitMultiplier = interval.quantity * exports.ES_FIXED_INTERVAL_UNIT_TO_BASE[interval.unit];
    var unixTimestamp = (0, chrono_1.getUnixTimestamp)(date, timeZone);
    var roundedDate = Math.floor(unixTimestamp / unitMultiplier) * unitMultiplier;
    return snapTo === 'start' ? roundedDate : roundedDate + unitMultiplier - 1;
}
//# sourceMappingURL=elasticsearch.js.map