import PropTypes from "prop-types";
var DIRECTIONS = ["asc", "desc", ""];
var SortOption = PropTypes.shape({
  // A display name, like "Name"
  name: PropTypes.string,
  // A field name, like "name".
  value: PropTypes.string,
  // asc or desc
  direction: PropTypes.oneOf(["asc", "desc", ""])
});

SortOption.create = function (_ref) {
  var name = _ref.name,
      value = _ref.value,
      direction = _ref.direction;

  if (!DIRECTIONS.includes(direction)) {
    direction = "";
  }

  return {
    name: name,
    value: value,
    direction: direction
  };
};

export default SortOption;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy90eXBlcy9Tb3J0T3B0aW9uLmpzIl0sIm5hbWVzIjpbIlByb3BUeXBlcyIsIkRJUkVDVElPTlMiLCJTb3J0T3B0aW9uIiwic2hhcGUiLCJuYW1lIiwic3RyaW5nIiwidmFsdWUiLCJkaXJlY3Rpb24iLCJvbmVPZiIsImNyZWF0ZSIsImluY2x1ZGVzIl0sIm1hcHBpbmdzIjoiQUFBQSxPQUFPQSxTQUFQLE1BQXNCLFlBQXRCO0FBRUEsSUFBTUMsVUFBVSxHQUFHLENBQUMsS0FBRCxFQUFRLE1BQVIsRUFBZ0IsRUFBaEIsQ0FBbkI7QUFDQSxJQUFNQyxVQUFVLEdBQUdGLFNBQVMsQ0FBQ0csS0FBVixDQUFnQjtBQUNqQztBQUNBQyxFQUFBQSxJQUFJLEVBQUVKLFNBQVMsQ0FBQ0ssTUFGaUI7QUFHakM7QUFDQUMsRUFBQUEsS0FBSyxFQUFFTixTQUFTLENBQUNLLE1BSmdCO0FBS2pDO0FBQ0FFLEVBQUFBLFNBQVMsRUFBRVAsU0FBUyxDQUFDUSxLQUFWLENBQWdCLENBQUMsS0FBRCxFQUFRLE1BQVIsRUFBZ0IsRUFBaEIsQ0FBaEI7QUFOc0IsQ0FBaEIsQ0FBbkI7O0FBU0FOLFVBQVUsQ0FBQ08sTUFBWCxHQUFvQixnQkFBcUM7QUFBQSxNQUExQkwsSUFBMEIsUUFBMUJBLElBQTBCO0FBQUEsTUFBcEJFLEtBQW9CLFFBQXBCQSxLQUFvQjtBQUFBLE1BQWJDLFNBQWEsUUFBYkEsU0FBYTs7QUFDdkQsTUFBSSxDQUFDTixVQUFVLENBQUNTLFFBQVgsQ0FBb0JILFNBQXBCLENBQUwsRUFBcUM7QUFDbkNBLElBQUFBLFNBQVMsR0FBRyxFQUFaO0FBQ0Q7O0FBRUQsU0FBTztBQUNMSCxJQUFBQSxJQUFJLEVBQUpBLElBREs7QUFFTEUsSUFBQUEsS0FBSyxFQUFMQSxLQUZLO0FBR0xDLElBQUFBLFNBQVMsRUFBVEE7QUFISyxHQUFQO0FBS0QsQ0FWRDs7QUFZQSxlQUFlTCxVQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuXG5jb25zdCBESVJFQ1RJT05TID0gW1wiYXNjXCIsIFwiZGVzY1wiLCBcIlwiXTtcbmNvbnN0IFNvcnRPcHRpb24gPSBQcm9wVHlwZXMuc2hhcGUoe1xuICAvLyBBIGRpc3BsYXkgbmFtZSwgbGlrZSBcIk5hbWVcIlxuICBuYW1lOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAvLyBBIGZpZWxkIG5hbWUsIGxpa2UgXCJuYW1lXCIuXG4gIHZhbHVlOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAvLyBhc2Mgb3IgZGVzY1xuICBkaXJlY3Rpb246IFByb3BUeXBlcy5vbmVPZihbXCJhc2NcIiwgXCJkZXNjXCIsIFwiXCJdKVxufSk7XG5cblNvcnRPcHRpb24uY3JlYXRlID0gZnVuY3Rpb24oeyBuYW1lLCB2YWx1ZSwgZGlyZWN0aW9uIH0pIHtcbiAgaWYgKCFESVJFQ1RJT05TLmluY2x1ZGVzKGRpcmVjdGlvbikpIHtcbiAgICBkaXJlY3Rpb24gPSBcIlwiO1xuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBuYW1lLFxuICAgIHZhbHVlLFxuICAgIGRpcmVjdGlvblxuICB9O1xufTtcblxuZXhwb3J0IGRlZmF1bHQgU29ydE9wdGlvbjtcbiJdfQ==