"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reconfigureLogging = reconfigureLogging;
exports.setupLogging = setupLogging;

var _good = require("@elastic/good");

var _get_logging_config = require("./get_logging_config");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// @ts-expect-error missing typedef
async function setupLogging(server, config, opsInterval) {
  // NOTE: legacy logger creates a new stream for each new access
  // In https://github.com/elastic/kibana/pull/55937 we reach the max listeners
  // default limit of 10 for process.stdout which starts a long warning/error
  // thrown every time we start the server.
  // In order to keep using the legacy logger until we remove it I'm just adding
  // a new hard limit here.
  process.stdout.setMaxListeners(60);
  return await server.register({
    plugin: _good.plugin,
    options: (0, _get_logging_config.getLoggingConfiguration)(config, opsInterval)
  });
}

function reconfigureLogging(server, config, opsInterval) {
  const loggingOptions = (0, _get_logging_config.getLoggingConfiguration)(config, opsInterval);
  server.plugins.good.reconfigure(loggingOptions);
}