/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the DefaultBooleanTrue as:
 *   - If null or undefined, then a default true will be set
 */
export var DefaultBooleanTrue = new t.Type('DefaultBooleanTrue', t["boolean"].is, function (input, context) {
  return input == null ? t.success(true) : t["boolean"].validate(input, context);
}, t.identity);