import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { isObject } from 'lodash/fp';
export var formatErrors = function formatErrors(errors) {
  var err = errors.map(function (error) {
    if (error.message != null) {
      return error.message;
    } else {
      var keyContext = error.context.filter(function (entry) {
        return entry.key != null && !Number.isInteger(+entry.key) && entry.key.trim() !== '';
      }).map(function (entry) {
        return entry.key;
      }).join(',');
      var nameContext = error.context.find(function (entry) {
        return entry.type != null && entry.type.name != null && entry.type.name.length > 0;
      });
      var suppliedValue = keyContext !== '' ? keyContext : nameContext != null ? nameContext.type.name : '';
      var value = isObject(error.value) ? JSON.stringify(error.value) : error.value;
      return "Invalid value \"".concat(value, "\" supplied to \"").concat(suppliedValue, "\"");
    }
  });
  return _toConsumableArray(new Set(err));
};