"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asyncForEach = asyncForEach;
exports.asyncForEachWithLimit = asyncForEachWithLimit;

var _operators = require("rxjs/operators");

var _rxjs_ = require("../rxjs_7");

var _observable = require("./observable");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Creates a promise which resolves with `undefined` after calling `fn` for each
 * item in `iterable`. `fn` can return either a Promise or Observable. If `fn`
 * returns observables then they will properly abort if an error occurs.
 *
 * @param iterable Items to iterate
 * @param fn Function to call for each item
 */
async function asyncForEach(iterable, fn) {
  await (0, _rxjs_.lastValueFrom)((0, _observable.mapWithLimit$)(iterable, Infinity, fn).pipe((0, _operators.defaultIfEmpty)()));
}
/**
 * Creates a promise which resolves with `undefined` after calling `fn` for each
 * item in `iterable`. `fn` can return either a Promise or Observable. If `fn`
 * returns observables then they will properly abort if an error occurs.
 *
 * The number of concurrent executions of `fn` is limited by `limit`.
 *
 * @param iterable Items to iterate
 * @param limit Maximum number of operations to run in parallel
 * @param fn Function to call for each item
 */


async function asyncForEachWithLimit(iterable, limit, fn) {
  await (0, _rxjs_.lastValueFrom)((0, _observable.mapWithLimit$)(iterable, limit, fn).pipe((0, _operators.defaultIfEmpty)()));
}